#include <bits/stdc++.h>
#include <numeric>

using namespace std;

const long long N_max = 5e5 + 1;
const long long M_max = 5e5 + 1;
const long long Q_max = 5e5 + 1;

long long N, M, Q;

struct laser
{
    long long x1, y1;
    long long x2, y2;
    long long x3, y3;
    long long x4, y4;
};

long long a[N_max], b[N_max];
long long x[M_max], y[M_max];
pair <long long, long long> S[Q_max];

bool dp[M_max];
long long result[M_max];

laser l[N_max];

bool cmp(pair <long long, long long> &a, pair <long long, long long> &b)
{
    if (a.first != b.first)
    {
        return a.first > b.first;
    }

    return a.second > b.second;
}

void InitLaser(long long i, long long q)
{
    l[q].x1 = a[q] - S[i].first / 2;
    l[q].y1 = b[q] + S[i].first / 2;

    l[q].x2 = a[q] + S[i].first / 2;
    l[q].y2 = b[q] + S[i].first / 2;

    l[q].x3 = a[q] - S[i].first / 2;
    l[q].y3 = b[q] - S[i].first / 2;

    l[q].x4 = a[q] + S[i].first / 2;
    l[q].y4 = b[q] - S[i].first / 2;
}

int check(long long q)
{
    int ret = INT_MAX;

    for (int i = 0; i < N; i++)
    {
        int dist1, dist2;

        dist1 = abs(x[q] - a[i]);
        dist2 = abs(y[q] - b[i]);

        int minDist = min(dist1, dist2);

        ret = min(ret, minDist);
    }

    return ret;
}

int main()
{
    ios::sync_with_stdio(0);
    cin.tie(0);

    cin >> N >> M;

    for (long long i = 0; i < N; i++)
    {
        cin >> a[i] >> b[i];
    }

    for (long long i = 0; i < M; i++)
    {
        cin >> x[i] >> y[i];

        dp[i] = 0;
    }

    cin >> Q;

    for (long long i = 0; i < Q; i++)
    {
        cin >> S[i].first;

        S[i].second = i;
    }

    for (int i = 0; i < M; i++)
    {
        result[i] = check(i);
    }

    for (int i = 0; i < Q; i++)
    {
        int ans = 0;

        for (int q = 0; q < M; q++)
        {
            if (result[q] <= S[i].first / 2)
            {
                ans++;
            }
        }

        cout << ans << " ";
    }

    cout << endl;

    return 0;
}
