#include <bits/stdc++.h>
using namespace std;

const int MAX_N=5*1e5+1;
int N, M, Q;
long centers_x[MAX_N], centers_y[MAX_N];
pair<int, int> points[MAX_N];
long limits_line[MAX_N], limits_column[MAX_N];
long S[MAX_N];
bool is_visited[MAX_N];

bool bs_line(const long& x, const long& S)
{
    int l=0, r=N-1, m;

    while(l<=r)
    {
        m=(l+r)/2;

        if(x>=centers_x[m]-S/2)
        {
            if(x<=centers_x[m]+S/2)
            {
                return true;
            }
            else
            {
                l=m+1;
            }
        }
        else
        {
            r=m-1;
        }
    }

    return false;
}

bool bs_column(const long& y, const long& S)
{
    int l=0, r=N-1, m;

    while(l<=r)
    {
        m=(l+r)/2;

        if(y>=centers_y[m]-S/2)
        {
            if(y<=centers_y[m]+S/2)
            {
                return true;
            }
            else
            {
                l=m+1;
            }
        }
        else
        {
            r=m-1;
        }
    }

    return false;
}


int main()
{
    ios_base::sync_with_stdio(false);
    cin.tie(nullptr);
    cout.tie(nullptr);

    cin >> N >> M;

    for(int i=0; i<N; i++)
    {
        cin >> centers_x[i] >> centers_y[i];
    }

    for(int i=0; i<M; i++)
    {
        cin >> points[i].first >> points[i].second;
    }

    sort(centers_x, centers_x+N);
    sort(centers_y, centers_y+N);

    cin >> Q;

    for(int i=0; i<Q; i++)
    {
        cin >> S[i];
    }

    sort(S, S+Q);

    for(int t=0; t<Q; t++)
    {
        int count_points=0;

        for(int i=0; i<M; i++)
        {
            if(bs_line(points[i].first, S[t]))
            {
                is_visited[i]=true;
                count_points++;
            }
            else
            {
                if(bs_column(points[i].second, S[t]))
                {
                    is_visited[i]=true;
                    count_points++;
                }
            }
        }

        cout << count_points << " ";
    }
    return 0;
}
