#include <bits/stdc++.h>
using namespace std;

const int MAX_N=5*1e5+1;
int N, M, Q;
pair<long, long> centers[MAX_N], points[MAX_N], reversed_centers[MAX_N];
long limits_line[MAX_N], limits_column[MAX_N];
bool is_visited[MAX_N];

bool bs_line(const long& x, const long& S)
{
    int l=0, r=N-1, m;

    while(l<=r)
    {
        m=(l+r)/2;

        if(x>=limits_line[m])
        {
            if(limits_line[m]+S>=x)
            {
                return true;
            }
            else
            {
                l=m+1;
            }
        }
        else
        {
            r=m-1;
        }
    }

    return false;
}

bool bs_column(const long& y, const long& S)
{
    int l=0, r=N-1, m;

    while(l<=r)
    {
        m=(l+r)/2;

        if(y>=limits_column[m])
        {
            if(limits_column[m]+S>=y)
            {
                return true;
            }
            else
            {
                l=m+1;
            }
        }
        else
        {
            r=m-1;
        }
    }

    return false;
}


int main()
{
    ios_base::sync_with_stdio(false);
    cin.tie(nullptr);
    cout.tie(nullptr);

    cin >> N >> M;

    for(int i=0; i<N; i++)
    {
        cin >> centers[i].first >> centers[i].second;
        reversed_centers[i]={centers[i].second, centers[i].first};
    }

    for(int i=0; i<M; i++)
    {
        cin >> points[i].first >> points[i].second;
    }

    sort(centers, centers+N);
    sort(points, points+M);
    sort(reversed_centers, reversed_centers+N);

    cin >> Q;

    bool is_over=false;

    for(int t=1; t<=Q; t++)
    {
        long S;
        cin >> S;

        if(!is_over)
        {
            int count_points=0;

            for(int i=0; i<N; i++)
            {
                limits_line[i]=centers[i].first-S/2;
                limits_column[i]=reversed_centers[i].first-S/2;
            }

            for(int i=0; i<M; i++)
            {
                if(bs_line(points[i].first, S))
                {
                    count_points++;
                    continue;
                }

                if(bs_column(points[i].second, S))
                {
                    count_points++;
                    continue;
                }
            }

            cout << count_points << " ";

            if(count_points==M)
            {
                is_over=true;
            }
        }
        else
        {
            cout << M << " ";
        }
    }
    return 0;
}

