#include <iostream>
#include <algorithm>
#include <vector>
#include <set>

using namespace std;

const int maxn = 500005;

int n, m;

pair<long long, long long> centers[maxn];
pair<long long, long long> points[maxn];

long long minDiff[maxn];

vector<long long> sortedX;
vector<long long> sortedY;

int bs1(long long x) {
    int l = 0;
    int r = sortedX.size() - 1;

    while (l <= r) {
        int mid = (l + r) / 2;

        if (sortedX[mid] >= x) r = mid - 1;
        else l = mid + 1;
    }

    return l;
}

int bs2(long long x) {
    int l = 0;
    int r = sortedY.size() - 1;

    while (l <= r) {
        int mid = (l + r) / 2;

        if (sortedY[mid] >= x) r = mid - 1;
        else l = mid + 1;
    }

    return l;
}

int main() {
    ios_base::sync_with_stdio(0); cin.tie(0); cout.tie(0);

    cin >> n >> m;

    for (int i = 1; i <= n; ++i) {
        cin >> centers[i].first >> centers[i].second;
    }

    for (int i = 1; i <= m; ++i) {
        cin >> points[i].first >> points[i].second;
    }

    for (int i = 1; i <= n; ++i) {
        sortedX.push_back(centers[i].first);
    }

    for (int i = 1; i <= n; ++i) {
        sortedY.push_back(centers[i].second);
    }

    sort(sortedX.begin(), sortedX.end());
    sort(sortedY.begin(), sortedY.end());

    //for (int i = 0; i < n; ++i) cout << sortedX[i] << " "; cout << endl;
    //for (int i = 0; i < n; ++i) cout << sortedY[i] << " "; cout << endl;

    for (int i = 1; i <= m; ++i) {
        int idx1 = bs1(points[i].first);
        int idx2 = idx1 - 1;

        if (idx1 < n) minDiff[i] = abs(points[i].first - sortedX[idx1]);
        if (idx2 >= 0) minDiff[i] = min(minDiff[i], abs(points[i].first - sortedX[idx2]));

        int idx3 = bs2(points[i].second);
        int idx4 = idx3 - 1;

        if (idx3 < n) minDiff[i] = min(minDiff[i], abs(points[i].second - sortedY[idx3]));
        if (idx4 >= 0) minDiff[i] = min(minDiff[i], abs(points[i].second - sortedY[idx4]));

        //cout << i << " " << idx1 << " " << idx2 << " " << idx3 << " " << idx4 << endl;
    }

    //cout << "print minDiff" << endl;

    /*for (int i = 1; i <= m; ++i) {
        cout << minDiff[i] << " ";
    }

    cout << endl;*/

    sort(minDiff + 1, minDiff + m + 1);

    int q; cin >> q;

    vector<int> ans;

    while (q--) {
        long long s; cin >> s;
        s /= 2;

        int l = 1;
        int r = m;

        while (l <= r) {
            int mid = (l + r) / 2;

            if (minDiff[mid] <= s) l = mid + 1;
            else r = mid - 1;
        }

        ans.push_back(r);
    }

    for (auto x : ans) cout << x << " ";
    cout << endl;

    return 0;
}
