#include <iostream>
#include <algorithm>
#include <vector>
#include <set>

using namespace std;

const int maxn = 500005;

int n, m;

pair<int, int> centers[maxn];
pair<int, int> points[maxn];

int minDiff[maxn];

vector<int> sortedX;
vector<int> sortedY;

int bs1(int x) {
    int l = 0;
    int r = sortedX.size() - 1;

    while (l <= r) {
        int mid = (l + r) / 2;

        if (sortedX[mid] >= x) r = mid - 1;
        else l = mid + 1;
    }

    return l;
}

int bs2(int x) {
    int l = 0;
    int r = sortedX.size() - 1;

    while (l <= r) {
        int mid = (l + r) / 2;

        if (sortedX[mid] >= x) r = mid - 1;
        else l = mid + 1;
    }

    return r;
}

int bs3(int x) {
    int l = 0;
    int r = sortedY.size() - 1;

    while (l <= r) {
        int mid = (l + r) / 2;

        if (sortedY[mid] >= x) r = mid - 1;
        else l = mid + 1;
    }

    return l;
}

int bs4(int x) {
    int l = 0;
    int r = sortedY.size() - 1;

    while (l <= r) {
        int mid = (l + r) / 2;

        if (sortedY[mid] >= x) r = mid - 1;
        else l = mid + 1;
    }

    return r;
}

int main() {
    ios_base::sync_with_stdio(0); cin.tie(0); cout.tie(0);

    cin >> n >> m;

    for (int i = 1; i <= n; ++i) {
        cin >> centers[i].first >> centers[i].second;
    }

    for (int i = 1; i <= m; ++i) {
        cin >> points[i].first >> points[i].second;
    }

    for (int i = 1; i <= n; ++i) {
        sortedX.push_back(centers[i].first);
    }

    for (int i = 1; i <= n; ++i) {
        sortedY.push_back(centers[i].second);
    }

    sort(sortedX.begin(), sortedX.end());
    sort(sortedY.begin(), sortedY.end());

    //for (int i = 0; i < n; ++i) cout << sortedX[i] << " "; cout << endl;
    //for (int i = 0; i < n; ++i) cout << sortedY[i] << " "; cout << endl;

    for (int i = 1; i <= m; ++i) {
        int idx1 = bs1(points[i].first) + 1;
        int idx2 = bs2(points[i].first) + 1;

        if (idx1 <= n) minDiff[i] = abs(points[i].first - centers[idx1].first);
        if (idx2 >= 1) minDiff[i] = min(minDiff[i], abs(points[i].first - centers[idx2].first));

        int idx3 = bs3(points[i].second) + 1;
        int idx4 = bs4(points[i].second) + 1;

        if (idx3 <= n) minDiff[i] = min(minDiff[i], abs(points[i].second - centers[idx3].second));
        if (idx4 >= 1) minDiff[i] = min(minDiff[i], abs(points[i].second - centers[idx4].second));
    }

    /*cout << "print minDiff" << endl;

    for (int i = 1; i <= m; ++i) {
        cout << minDiff[i] << " ";
    }

    cout << endl;*/

    sort(minDiff + 1, minDiff + m + 1);

    int q; cin >> q;

    while (q--) {
        int s; cin >> s;
        s /= 2;

        int idx = upper_bound(minDiff + 1, minDiff + m + 1, s) - minDiff;

        cout << idx - 1 << " ";
    }
    cout << endl;

    return 0;
}
