#include <iostream>
#include <algorithm>
#include <vector>
#include <set>

using namespace std;

const int maxn = 500005;

int n, m;

pair<int, int> centers[maxn];
pair<int, int> points[maxn];

int minDiff[maxn];

int main() {
    ios_base::sync_with_stdio(0); cin.tie(0); cout.tie(0);

    cin >> n >> m;

    for (int i = 1; i <= n; ++i) {
        cin >> centers[i].first >> centers[i].second;
    }

    for (int i = 1; i <= m; ++i) {
        cin >> points[i].first >> points[i].second;
    }

    vector<int> sortedX;
    vector<int> sortedY;

    for (int i = 1; i <= n; ++i) {
        sortedX.push_back(centers[i].first);
    }

    for (int i = 1; i <= n; ++i) {
        sortedY.push_back(centers[i].second);
    }

    sort(sortedX.begin(), sortedX.end());
    sort(sortedY.begin(), sortedY.end());

    for (int i = 0; i < n; ++i) cout << sortedX[i] << " "; cout << endl;
    for (int i = 0; i < n; ++i) cout << sortedY[i] << " "; cout << endl;

    for (int i = 1; i <= m; ++i) {
        int idx1 = lower_bound(sortedX.begin(), sortedX.end(), points[i].first) - sortedX.begin();
        idx1++;

        //cout << "for i = " << i << endl;

        //cout << points[i].first << endl;

        //cout << i << " " << idx1 << endl;

        if (idx1 == n + 1) {
            idx1--;
            minDiff[i] = abs(points[i].first - centers[idx1].first);
        } else {
            minDiff[i] = abs(points[i].first - centers[idx1].first);

            idx1--;
            if (idx1 != 1) {
                minDiff[i] = min(minDiff[i], abs(points[i].first - centers[idx1].first));
            }
        }

        int idx2 = lower_bound(sortedY.begin(), sortedY.end(), points[i].second) - sortedY.begin();
        idx2++;

        //cout << points[i].second << endl;

        //cout << i << " " << idx2 << endl;

        if (idx2 == n + 1) {
            idx2--;
            minDiff[i] = min(minDiff[i], abs(points[i].second - centers[idx2].second));
        } else {
            minDiff[i] = min(minDiff[i], abs(points[i].second - centers[idx2].second));

            idx2--;
            if (idx2 != 1) {
                minDiff[i] = min(minDiff[i], abs(points[i].second - centers[idx2].second));
            }
        }

        //cout << minDiff[i] << endl;
        //cout << "------------------" << endl;
    }

    /*cout << "print minDiff" << endl;

    for (int i = 1; i <= m; ++i) {
        cout << minDiff[i] << " ";
    }

    cout << endl;*/

    sort(minDiff + 1, minDiff + m + 1);

    int q; cin >> q;

    while (q--) {
        int s; cin >> s;
        s /= 2;

        int idx = upper_bound(minDiff + 1, minDiff + m + 1, s) - minDiff;

        cout << idx - 1 << " ";
    }
    cout << endl;

    return 0;
}
