#include <iostream>
#include <algorithm>
#include <vector>
#include <set>

using namespace std;

const int maxn = 500005;

int n, m;

pair<int, int> centers[maxn];
pair<int, int> points[maxn];

int minDiff[maxn];

int main() {
    ios_base::sync_with_stdio(0); cin.tie(0); cout.tie(0);

    cin >> n >> m;

    for (int i = 1; i <= n; ++i) {
        cin >> centers[i].first >> centers[i].second;
    }

    for (int i = 1; i <= m; ++i) {
        cin >> points[i].first >> points[i].second;
    }

    for (int i = 1; i <= m; ++i) {
        int minD = (1 << 30);

        for (int j = 1; j <= n; ++j) {
            minD = min(minD, min(abs(points[i].first - centers[j].first), abs(points[i].second - centers[j].second)));
        }

        minDiff[i] = minD;
    }

    sort(minDiff + 1, minDiff + m + 1);

    int q; cin >> q;

    while (q--) {
        int s; cin >> s;
        s /= 2;

        int idx = upper_bound(minDiff + 1, minDiff + m + 1, s) - minDiff;

        cout << idx - 1 << " ";
    }
    cout << endl;

    return 0;
}
