#include <iostream>
#include <vector>

using namespace std;

const int maxn = 500005;

int n, m;

pair<int, int> centers[maxn];
pair<int, int> points[maxn];

int main() {
    ios_base::sync_with_stdio(0); cin.tie(0); cout.tie(0);

    cin >> n >> m;

    for (int i = 1; i <= n; ++i) {
        cin >> centers[i].first >> centers[i].second;
    }

    for (int i = 1; i <= m; ++i) {
        cin >> points[i].first >> points[i].second;
    }

    int q; cin >> q;

    while (q--) {
        int s; cin >> s;
        s /= 2;

        vector<bool> isAns(m + 1, false);

        for (int i = 1; i <= n; ++i) {
            for (int j = 1; j <= m; ++j) {
                if (abs(centers[i].first - points[j].first) <= s || abs(centers[i].second - points[j].second) <= s) {
                    isAns[j] = true;
                }
            }
        }

        int ans = 0;

        for (int i = 1; i <= m; ++i) ans += isAns[i];

        cout << ans << " ";
    }

    cout << endl;

    return 0;
}
