#include <iostream>
#include <algorithm>

using namespace std;

const int maxn = 1e5 + 10;
long long n, q, a[maxn], tree[4 * maxn];

void read(){
    cin >> n >> q;
    for(int i = 1;i <= n;i++){
        cin >> a[i];
    }
}

void make_tree(int i, int l, int r){
    if(l == r){
        tree[i] = a[l];
        return;
    }
    int mid = (l + r) / 2;
    make_tree(2 * i, l, mid);
    make_tree(2 * i + 1, mid + 1, r);
    tree[i] = tree[2 * i] ^ tree[2 * i + 1];
}

long long query(int i, int l, int r, int ql, int qr){
    if(l == ql && r == qr){
        return tree[i];
    }
    int mid = (l + r) / 2;
    if(qr <= mid) return query(2 * i, l, mid, ql, qr);
    if(ql > mid) return query(2 * i + 1, mid + 1, r, ql, qr);
    return query(2 * i, l, mid, ql, mid) ^ query(2 * i + 1, mid + 1, r, mid + 1, qr);
}

void solve(){
    make_tree(1, 1, n);
    for(int i = 1;i <= q;i++){
        char sym;
        int l, r;
        cin >> sym >> l >> r;
        cout << query(1, 1, n, l, r) << endl;
    }
}

int main()
{
    ios_base::sync_with_stdio(false);
    cin.tie(0);
    cout.tie(0);
    read();
    solve();
    return 0;
}
