#include <iostream>
#include <algorithm>

using namespace std;

const int maxn = 2048;
int n, m, q, a[maxn], b[maxn], x[maxn], y[maxn], used[maxn];
int xleft[maxn], xright[maxn], yup[maxn], ydown[maxn];

struct answer{
    int x, idx;
}t[maxn];

bool cmp(answer t1, answer t2){
    return t1.x < t2.x;
}

void read(){
    cin >> n >> m;
    for(int i = 1;i <= n;i++){
        cin >> a[i] >> b[i];
    }
    for(int i = 1;i <= m;i++){
        cin >> x[i] >> y[i];
    }
    cin >> q;
    for(int i = 1;i <= q;i++){
        cin >> t[i].x;
        t[i].idx = i;
    }
    sort(t + 1, t + q + 1, cmp);
}

int ans[maxn];

void solve(int num){
    int s = t[num].x;
    for(int i = 1;i <= n;i++){
        xleft[i] = a[i] -  s / 2;
        xright[i] = a[i] + s / 2;
        yup[i] = b[i] + s / 2;
        ydown[i] = b[i] - s / 2;
    }
    int cnt = 0;
    for(int i = 1;i <= m;i++){
        if(used[i]) continue;
        int uv = 0;
        for(int j = 1;j <= n;j++){
            if((xleft[j] <= x[i] && x[i] <= xright[j]) || (ydown[j] <= y[i] && y[i] <= yup[j]))
                    uv = 1;
        }
        used[i] = uv;
    }
    for(int i = 1;i <= m;i++){
        cnt += used[i];
    }
    ans[t[num].idx] = cnt;
}
int main()
{
    ios_base::sync_with_stdio(false);
    cin.tie(0);
    cout.tie(0);
    read();
    for(int i = 1;i <= q;i++){
        solve(i);
    }
    for(int i = 1;i <= q;i++){
        cout << ans[i] << " ";
    }
    cout << endl;
    return 0;
}
