#include <iostream>
#include <vector>
#include <algorithm>

using namespace std;

const int maxn = 5e5 + 10;
int n, m, a[maxn], b[maxn], x[maxn], y[maxn];
int xleft[maxn], xright[maxn], yup[maxn], ydown[maxn];

void read(){
    cin >> n >> m;
    for(int i = 1;i <= n;i++){
        cin >> a[i] >> b[i];
    }
    for(int i = 1;i <= m;i++){
        cin >> x[i] >> y[i];
    }
}

struct point{
    int x, type, idx;
};

int used[maxn];

bool cmp(point p1, point p2){
    if(p1.x != p2.x) return p1.x < p2.x;
    if(p1.type == 0) return true;
    if(p2.type == 0) return false;
    if(p1.type == 2) return true;
    if(p2.type == 2) return false;
}

void solve(){
    int s;
    cin >> s;
    vector<point> v;
    for(int i = 1;i <= n;i++){
        xleft[i] = a[i] - s / 2;
        xright[i] = a[i] + s / 2;
        yup[i] = b[i] + s / 2;
        ydown[i] = b[i] - s / 2;
        used[i] = 0;
        v.push_back({xleft[i], 0, i});
        v.push_back({xright[i], 1, i});
    }
    for(int i = 1;i <= m;i++){
        v.push_back({x[i], 2, i});
    }
    sort(v.begin(), v.end(), cmp);
    int cnt = 0;
    for(point p : v){
        if(p.type == 0) cnt++;
        else if(p.type == 1) cnt--;
        else{
            if(cnt){
                used[p.idx] = 1;
            }
        }
    }
    cnt = 0;
    v.clear();
    for(int i = 1;i <= n;i++){
        v.push_back({ydown[i], 0, i});
        v.push_back({yup[i], 1, i});
    }
    for(int i = 1;i <= m;i++){
        v.push_back({y[i], 2, i});
    }
    sort(v.begin(), v.end(), cmp);
    for(point p : v){
        if(p.type == 0) cnt++;
        else if(p.type == 1) cnt--;
        else{
            if(cnt){
                used[p.idx] = 1;
            }
        }
    }
    int ans = 0;
    for(int i = 1;i <= m;i++){
        ans += used[i];
    }
    cout << ans << " ";
}
int main()
{
    ios_base::sync_with_stdio(false);
    cin.tie(0);
    cout.tie(0);
    read();
    int q;
    cin >> q;
    while(q--){
        solve();
    }
    cout << endl;
    return 0;
}
