#include<bits/stdc++.h>

using namespace std;

struct Point
{
    int t,ch;
    Point(){};
    Point(int ti, int chi)
    {
        t = ti;
        ch = chi;
    }
};

const int maxn = 1e5+5;
int n,q;
int a[maxn];
int tree[4*maxn][32];
Point lazy[4*maxn];
int ql,qr,k;
char c;
int li,ri,x;

void make_tree(int v, int l, int r)
{
    if(l==r)
    {
        for(int j=0;j<30;j++)
        {
            if(a[r]&(1<<j)) tree[v][j] = 1;
        }
        return;
    }
    int mid = (l+r)/2;
    make_tree(v*2+0,l,mid+0);
    make_tree(v*2+1,mid+1,r);
    for(int j=0;j<30;j++)
    {
        tree[v][j] = tree[v*2+0][j] + tree[v*2+1][j];
    }
}

void push_lazy(int v, int l, int r)
{
    if(lazy[v].t==0) return;
    for(int j=0;j<30;j++)
    {
        if(lazy[v].ch&(1<<j))
        {
            if(c=='|') tree[v][j] = r-l+1;
        }
        else
        {
            if(c=='&') tree[v][j] = 0;
        }
    }
    if(l!=r)
    {
        if(lazy[v*2+0].t)
        {
            if(c=='|') lazy[v*2+0].ch |= lazy[v].ch;
            else lazy[v*2+0].ch &= lazy[v].ch;
        }
        else lazy[v*2+0].ch = lazy[v].ch;

        if(lazy[v*2+1].t)
        {
            if(c=='|') lazy[v*2+1].ch |= lazy[v].ch;
            else lazy[v*2+1].ch &= lazy[v].ch;
        }
        else lazy[v*2+1].ch = lazy[v].ch;
        lazy[v*2+0].t = 1;
        lazy[v*2+1].t = 1;
    }
    lazy[v].t = 0;
    lazy[v].ch = 0;
}

int query(int v, int l, int r)
{
    push_lazy(v,l,r);
    if(r<ql||qr<l||l>r) return 0;
    if(ql<=l&&r<=qr) return tree[v][k];
    int mid = (l+r)/2;
    return query(v*2+0,l,mid+0) + query(v*2+1,mid+1,r);
}

void update(int v, int l, int r)
{
    push_lazy(v,l,r);
    if(r<ql||qr<l||l>r) return;
    if(ql<=l&&r<=qr)
    {
        lazy[v].t = 1;
        lazy[v].ch = x;
        push_lazy(v,l,r);
        return;
    }
    int mid = (l+r)/2;
    update(v*2+0,l,mid+0);
    update(v*2+1,mid+1,r);
    for(int j=0;j<30;j++)
    {
        tree[v][j] = tree[v*2+0][j] + tree[v*2+1][j];
    }
}

void print()
{
    long long ans = 0;
    long long step;
    ql = li;
    qr = ri;
    for(int j=0;j<30;j++)
    {
        step = (1<<j);
        k = j;
        int br1,br0;
        br1 = query(1,1,n);
        br0 = ri-li+1-br1;
        step *= br1;
        step *= br0;
        ans += step;
    }
    cout << ans << endl;
}

void solve()
{
    ql = li;
    qr = ri;
    update(1,1,n);
}

void read()
{
    cin >> n >> q;
    for(int i=1;i<=n;i++)
    {
        cin >> a[i];
    }
    make_tree(1,1,n);
    for(int i=1;i<=q;i++)
    {
        cin >> c;
        if(c=='?')
        {
            cin >> li >> ri;
            print();
        }
        else
        {
            cin >> li >> ri >> x;
            solve();
        }
    }
}
int main ()
{
    ios_base::sync_with_stdio(false);
    cin.tie(0);
    cout.tie(0);
    read();
    return 0;
}
