#include <bits/stdc++.h>
using namespace std;

enum { MAX_N=100000 };
unsigned a[MAX_N+1];

void dand(unsigned l, unsigned r, unsigned x)
{
    for (unsigned *i=a+l, *e=a+r; i<=e; ++i)
        *i &= x;
}

void dor(unsigned l, unsigned r, unsigned x)
{
    for (unsigned *i=a+l, *e=a+r; i<=e; ++i)
        *i |= x;
}

unsigned calc(unsigned l, unsigned r)
{
    unsigned sum=0;
    for (unsigned i=l; i<=r; ++i)
        for (unsigned j=i+1; j<=r; ++j)
            sum += a[i] ^ a[j];
    return sum;
}

void solve(char op, unsigned l, unsigned r, unsigned x)
{
        switch (op)
        {
        case '|':
            dor(l, r, x);
            break;
        case '&':
            dand(l, r, x);
            break;
        case '?':
            cout << calc(l, r) << '\n';
            break;
        }
}

int main()
{
    ios_base::sync_with_stdio(0);
    cin.tie(0), cout.tie(0);

    unsigned n, q;
    cin >> n >> q;

    for (unsigned i=1; i<=n; ++i)
        cin >> a[i];

    for (unsigned i=0; i<q; ++i)
    {
        char op;
        unsigned l, r, x;
        cin >> op >> l >> r;
        if (op != '?')
            cin >> x;
        solve(op, l, r, x);
    }

    return 0;
}
