#include<iostream>
#include<vector>
using namespace std;
const int MAXN = 2e6+7;
const long long int mod = 1e9+7;
typedef vector<vector<long long>> matrix;
long long dp[MAXN];
matrix operator*(const matrix& A,const matrix& B){
    int n=A.size(),m=A[0].size(),k=B.size();
    matrix C(n);
    for(int i=0;i<n;i++){
        C[i].resize(k);
        for(int j=0;j<k;j++){
            C[i][j]=0;
            for(int h=0;h<m;h++){
                C[i][j]+=(A[i][h]*B[h][j]);
                C[i][j]%=mod;
            }
        }
    }
    return C;
}
matrix POW(matrix& A,int n){
    if(n==1) return A;
    if(n%2==1) return POW(A,n-1)*A;
    matrix temp=POW(A,n/2);
    return temp*temp;
}
int main(){
    int n,k;
    cin>>n>>k;
    dp[0]=1;
    for(int i=1;i<=k;i++){
        if(i<=k) dp[i]++;
        for(int j=1;j<=k and i>j;j++) dp[i]+=dp[i-j];
        dp[i]%=mod;
    }/// namirame do dp[k], shte namerim dp[n] s umnojenie na matrici
    matrix A(1),T(k),ans;
    A[0].resize(k);
    for(int i=0;i<k;i++) A[0][i]=dp[i+1];
    for(int i=0;i<k;i++){
        T[i].resize(k);
        for(int j=0;j<k;j++){
            if(j==k-1) T[i][j]=1;
            else if(i-j==1) T[i][j]=1;
            else T[i][j]=0;
        }
    }
    //cout<<A.size()<<" "<<A[0].size()<<" "<<T.size()<<" "<<T[0].size()<<"\n";
    ans=A*POW(T,n-k);
    //for(auto to:ans[0]) cout<<to<<" ";
    cout<<ans[0][k-1]<<"\n";
    return 0;
}
