#include<bits/stdc++.h>
#define endl '\n'
#define ll long long
using namespace std;
const ll MAX_N = 1e5+2;
struct edge
{
    ll u,v,w;
    edge(){}
    edge(ll _u0, ll _v0, ll _w0) {
        u = _u0; v = _v0; w = _w0;
    }
};
struct cycle_info
{
    ll first_max,second_max,cycle_par;
}from_cycle[MAX_N];
ll tree[4*MAX_N];
vector< pair<ll,ll> > adj[MAX_N];
queue< pair<ll,ll> > q;
ll polls_to[MAX_N];
bool used[MAX_N], in_cycle[MAX_N];
ll cycle_size = 0, f=0;
ll pos_in_cycle[MAX_N], cycle_ar[MAX_N];
vector<ll> v_cycle;
queue< pair< ll, pair<ll,ll> > > q2;
void build_tree(ll node, ll tl, ll tr)
{
    if(tl == tr)
    {
        tree[node] = cycle_ar[tl];
        return;
    }
    ll mid = (tl+tr)/2;
    build_tree(node*2, tl, mid);
    build_tree(node*2+1, mid+1, tr);
    tree[node] = max(tree[node*2],tree[node*2+1]);
}
ll query(ll node, ll tl, ll tr, ll l, ll r)
{
    if(tl > r || tr < l) return 0;
    if(tl >= l && tr <= r) return tree[node];
    ll mid = (tl+tr)/2;
    return max( query(node*2, tl, mid, l, r), query(node*2+1, mid+1, tr, l, r));
}
void extract_cycle(ll firstv)
{
    while(!q.empty() && q.front().first != firstv) q.pop();
    while(!q.empty()) {
        in_cycle[q.front().first] = 1;
        v_cycle.push_back(q.front().first);
        pos_in_cycle[q.front().first] = ++cycle_size;
        cycle_ar[cycle_size] = q.front().second;
        q.pop();
    }
}
void dfs(ll cur, ll par)
{
    used[cur] = 1;
    if(f == 1) return;
    for(auto x: adj[cur])
    {
        if(x.first == par) continue;
        q.push({cur,x.second});
        if(used[x.first] == 1)
        {
            extract_cycle(x.first);
            f=1;
            return;
        }
        dfs(x.first, cur);
    }
}
void update_cycle(ll idx, ll new_edge)
{
    if(from_cycle[idx].first_max <= new_edge)
    {
        from_cycle[idx].second_max = from_cycle[idx].first_max;
        from_cycle[idx].first_max = new_edge;
    }
    else if(from_cycle[idx].second_max <= new_edge)
    {
        from_cycle[idx].second_max = new_edge;
    }
}
int main()
{
    ios_base::sync_with_stdio(false);
    cin.tie(NULL);
    cout.tie(NULL);
    ll n,u0,v0,w0;
    cin>>n;
    for(ll i=0; i<n; i++)
    {
        cin>>u0>>v0>>w0;
        adj[u0].push_back({v0,w0});
        adj[v0].push_back({u0,w0});
    }
    dfs(1,-1);
//    for(ll i=0; i<=cycle_size+2; i++)
//        cout<<pos_in_cycle[i]<<" ";
//    cout<<endl;
//    for(ll i=0; i<=cycle_size+2; i++)
//        cout<<cycle_ar[i]<<" ";
//    cout<<endl;
    for(auto x: v_cycle)
    {
        from_cycle[x].cycle_par = x;
        for(auto y: adj[x])
        {
            if(in_cycle[y.first] == 1) continue;
            q2.push({y.first,{x, y.second}});
        }
    }
    while(!q2.empty())
    {
        ll cur_v = q2.front().first;
        ll par_v = q2.front().second.first;
        ll in_edge = q2.front().second.second;
        q2.pop();
        from_cycle[cur_v] = from_cycle[par_v];
        update_cycle(cur_v,in_edge);
        for(auto x: adj[cur_v])
        {
            if(x.first != par_v)
            {
                q2.push({x.first,{cur_v, x.second}});
            }
        }
    }
    for(ll i=1; i<=n; i++)
    {
        //cout<<i<<" "<<from_cycle[i].first_max<<" "<<from_cycle[i].second_max<<" "<<from_cycle[i].cycle_par<<endl;
    }
    build_tree(1,1,cycle_size);
    for(ll i=1; i<=n; i++) polls_to[i] = i;
    long long ans = 0;
    ll q,type;
    //cout<<endl;
    cin>>q;
    for(ll i=0; i<q; i++)
    {
        cin>>type>>u0>>v0;
        pair<ll,ll> temp = {0,0};
        if(type == 1)
        {
            u0 = polls_to[u0];
            v0 = polls_to[v0];

            temp.first = max(from_cycle[u0].first_max,from_cycle[v0].first_max);
            temp.second = temp.first;

            ll le = from_cycle[u0].cycle_par;
            ll ri = from_cycle[v0].cycle_par;
            //cout<<le<<" "<<ri<<endl;
            le = pos_in_cycle[le];
            ri = pos_in_cycle[ri];
            if(le >= ri) swap(le,ri);

            ll normal_query = query(1,1,cycle_size,le,ri-1);

            ll divided_query = 0;
            divided_query = max(divided_query,query(1,1,cycle_size,1,le-1));
            divided_query = max(divided_query, query(1,1,cycle_size,ri,cycle_size));

            temp.first = max(temp.first,normal_query);

            temp.second = max(temp.second, divided_query);

            ////cout<<normal_query<<" "<<divided_query<<endl;
            cout<<temp.first  <<" "<<temp.second<<endl;
            ans+=max(temp.first,temp.second)*2+min(temp.first,temp.second);
            ////cout<<endl;
        }
        if(type == 2) swap(polls_to[u0],polls_to[v0]);
    }
    cout<<ans<<endl;

}
/**
7
1 3 1
3 5 2
5 6 3
2 6 4
2 4 5
4 1 6
5 7 8
7
1 1 5
2 1 5
1 1 5
1 6 1
1 7 5
1 7 4
1 7 6
*/
/**
9
1 2 1
2 3 1
3 4 6
4 1 8
2 5 4
2 6 8
5 7 4
5 8 9
4 9 2
9
1 1 2
1 5 9
1 7 3
1 8 1
1 6 9
2 1 3
1 8 1
2 1 4
1 8 1
*/
