#include<bits/stdc++.h>
#define endl '\n'
using namespace std;
const int MAX_N = 1e5+2;
struct edge
{
    int u,v,w;
    edge(){}
    edge(int _u0, int _v0, int _w0) {
        u = _u0; v = _v0; w = _w0;
    }
};
struct cycle_info
{
    int first_max,second_max,cycle_par;
}from_cycle[MAX_N];
int tree[4*MAX_N];
vector< pair<int,int> > adj[MAX_N];
queue< pair<int,int> > q;
int points_to[MAX_N];
bool used[MAX_N], in_cycle[MAX_N];
int cycle_size = 0, f=0;
int pos_in_cycle[MAX_N], cycle_ar[MAX_N];
vector<int> v_cycle;
queue< pair< int, pair<int,int> > > q2;
void build_tree(int node, int tl, int tr)
{
    if(tl == tr)
    {
        tree[node] = cycle_ar[tl];
        return;
    }
    int mid = (tl+tr)/2;
    build_tree(node*2, tl, mid);
    build_tree(node*2+1, mid+1, tr);
    tree[node] = max(tree[node*2],tree[node*2+1]);
}
int query(int node, int tl, int tr, int l, int r)
{
    if(tl > r || tr < l) return 0;
    if(tl >= l && tr <= r) return tree[node];
    int mid = (tl+tr)/2;
    return max( query(node*2, tl, mid, l, r), query(node*2+1, mid+1, tr, l, r));
}
void extract_cycle(int firstv)
{
    while(!q.empty() && q.front().first != firstv) q.pop();
    while(!q.empty()) {
        in_cycle[q.front().first] = 1;
        v_cycle.push_back(q.front().first);
        pos_in_cycle[q.front().first] = ++cycle_size;
        cycle_ar[cycle_size] = q.front().second;
        q.pop();
    }
}
void dfs(int cur, int par)
{
    used[cur] = 1;
    if(f == 1) return;
    for(auto x: adj[cur])
    {
        if(x.first == par) continue;
        q.push({cur,x.second});
        if(used[x.first] == 1)
        {
            extract_cycle(x.first);
            f=1;
            return;
        }
        dfs(x.first, cur);
    }
}
void update_cycle(int idx, int new_edge)
{
    if(from_cycle[idx].first_max <= new_edge)
    {
        from_cycle[idx].second_max = from_cycle[idx].first_max;
        from_cycle[idx].first_max = new_edge;
    }
    else if(from_cycle[idx].second_max <= new_edge)
    {
        from_cycle[idx].second_max = new_edge;
    }
}
int main()
{
    ios_base::sync_with_stdio(false);
    cin.tie(NULL);
    cout.tie(NULL);
    int n,u0,v0,w0;
    cin>>n;
    for(int i=0; i<n; i++)
    {
        cin>>u0>>v0>>w0;
        adj[u0].push_back({v0,w0});
        adj[v0].push_back({u0,w0});
    }
    dfs(1,-1);
//    for(int i=0; i<=cycle_size+2; i++)
//        cout<<pos_in_cycle[i]<<" ";
//    cout<<endl;
//    for(int i=0; i<=cycle_size+2; i++)
//        cout<<cycle_ar[i]<<" ";
//    cout<<endl;
    for(auto x: v_cycle)
    {
        from_cycle[x].cycle_par = x;
        for(auto y: adj[x])
        {
            if(in_cycle[y.first] == 1) continue;
            q2.push({y.first,{x, y.second}});
        }
    }
    while(!q2.empty())
    {
        int cur_v = q2.front().first;
        int par_v = q2.front().second.first;
        int in_edge = q2.front().second.second;
        q2.pop();
        from_cycle[cur_v] = from_cycle[par_v];
        update_cycle(cur_v,in_edge);
        for(auto x: adj[cur_v])
        {
            if(x.first != par_v)
            {
                q2.push({x.first,{cur_v, x.second}});
            }
        }
    }
    for(int i=1; i<=n; i++)
    {
        //cout<<i<<" "<<from_cycle[i].first_max<<" "<<from_cycle[i].second_max<<" "<<from_cycle[i].cycle_par<<endl;
    }
    build_tree(1,1,cycle_size);
    for(int i=1; i<=n; i++) points_to[i] = i;
    long long ans = 0;
    int q,type;
    //cout<<endl;
    cin>>q;
    for(int i=0; i<q; i++)
    {
        cin>>type>>u0>>v0;
        pair<int,int> temp = {0,0};
        if(type == 1)
        {
            u0 = points_to[u0];
            v0 = points_to[v0];

            temp.first = max(from_cycle[u0].first_max,from_cycle[v0].first_max);
            temp.second = temp.first;

            int le = from_cycle[u0].cycle_par;
            int ri = from_cycle[v0].cycle_par;
            //cout<<le<<" "<<ri<<endl;
            le = pos_in_cycle[le];
            ri = pos_in_cycle[ri];
            if(le >= ri) swap(le,ri);

            int normal_query = query(1,1,cycle_size,le,ri-1);

            int divided_query = 0;
            divided_query = max(divided_query,query(1,1,cycle_size,1,le-1));
            divided_query = max(divided_query, query(1,1,cycle_size,ri,cycle_size));

            temp.first = max(temp.first,normal_query);

            temp.second = max(temp.second, divided_query);

            ////cout<<normal_query<<" "<<divided_query<<endl;
            //cout<<temp.first  <<" "<<temp.second<<endl;
            ans+=max(temp.first,temp.second)*2+min(temp.first,temp.second);
            ////cout<<endl;
        }
        if(type == 2) swap(points_to[u0],points_to[v0]);
    }
    cout<<ans<<endl;

}
/**
7
1 3 1
3 5 2
5 6 3
2 6 4
2 4 5
4 1 6
5 7 8
7
1 1 5
2 1 5
1 1 5
1 6 1
1 7 5
1 7 4
1 7 6
*/
