#include <bits/stdc++.h>
using namespace std;

int const MAXN=100001;
long long d[MAXN], inf = 1e18+7;
int n, m, k, used[MAXN];

struct edge
{
    int ver;
    long long dist;
    edge(int vr, int dt)
    {
        ver = vr;
        dist = dt;
    };
    edge(){};
    bool operator<(const edge &ed)const
    {
        return ed.dist < dist;
    }
};

vector<edge> v[100001];

void dijkstra(int s)
{
    for(int i=0;i<=n;i++)
    {
        d[i] = inf;
    }
    d[s] = 0;
    priority_queue<edge> q;
    q.push({s,0});
    while(!q.empty())
    {
        edge e = q.top();
        q.pop();
        int sz = v[e.ver].size();
        for(int i=0;i<sz;i++)
        {
            edge u = v[e.ver][i];
            if(u.dist <= d[u.ver])
            {
                if(!used[u.ver])
                {
                    used[u.ver] = 1;
                    if(u.dist + d[e.ver] < d[u.ver])
                    {
                        u.dist = u.dist + d[e.ver];
                        d[u.ver] = u.dist;
                        q.push(u);
                    }
                }
            }
        }
    }
}

void read()
{
    int x, y;
    long long dit;
    cin>>n>>m>>k;
    for(int i=1;i<=m;i++)
    {
        cin>>x>>y>>dit;
        v[x].push_back({y,dit});
        v[y].push_back({x,dit});
    }
    dijkstra(1);
    cout<<d[n]<<endl;
}

int main()
{
    read();
    return 0;
}
