#include<bits/stdc++.h>
using namespace std;
const long long maxn = 5000;
struct edge
{
    long long ver;
    long long prize;
    edge(){};
    edge( long long x, long long y )
    {
        ver = x;
        prize = y;
    }
    bool operator < ( const edge & e )const
    {
        return ( prize > e.prize );
    }
};

long long n,m,k;
unsigned long long path[maxn];
vector<edge>v[maxn];
long long ans = -1;

void read()
{
    cin >> n >> m >> k;
    for( long long i = 1; i <= m; i ++ )
    {
        long long x,y,z;
        cin >> x >> y >> z;
        edge e1(x,z);
        edge e2(y,z);

        v[y].push_back(e1);
        v[x].push_back(e2);
    }
}

void djikstra()
{
    memset(path,-1,sizeof(path));
    priority_queue<edge>q;
    path[1] = 0;
    edge e(1,0);
    q.push(e);

    while( !q.empty() )
    {
        edge w = q.top();
        q.pop();

        long long from = w.ver;

        if( w.prize <= path[from] )
        {
            long long sz = v[from].size();
            for( long long i = 0; i < sz; i ++ )
            {
                long long nb = v[from][i].ver;
                long long c = v[from][i].prize;

                if( path[from] + c < path[nb] )
                {
                    edge ne( nb , path[from] + c);
                    path[nb] = path[from] + c;
                    q.push(ne);
                }
            }
        }
    }

    cout << path[n] << endl;
}
int main()
{
    read();
    djikstra();
    return 0;
}
