#include<bits/stdc++.h>
using namespace std;
const int maxn = 1000001;
struct edge
{
    int ver;
    int prize;
    edge() {};
    edge( int x, int y )
    {
        ver = x;
        prize = y;
    }
};
int n,q;
int used[maxn];
int tree[maxn];
vector<edge>v[maxn];

vector<int>a;
vector<int>b;

int idx[maxn];
int idx_b[maxn];
int parent[maxn];
int max_edge[maxn];

void read()
{
    cin >> n;
    for( int i = 1; i <= n; i ++ )
    {
        idx[i] = i;

        int x,y,z;
        cin >> x >> y >> z;

        edge e1(x,z);
        edge e2(y,z);

        v[y].push_back(e1);
        v[x].push_back(e2);
    }
    memset(idx_b,-1,sizeof(idx_b));
}

int lamp = 0;
void find_cycle( int w, int par )
{
    used[w] = 1;
    int sz = v[w].size();

    for( int i = 0; i < sz; i ++ )
    {
        int nb = v[w][i].ver;
        int x = v[w][i].prize;

        if( used[nb] == 0 )
        {
            find_cycle(nb,w);
            if( lamp != 0 )
            {
                a.push_back(x);
                b.push_back(w);

                idx_b[w] = b.size() - 1;
                if( w == lamp ) lamp = 0;

                return;
            }
        }
        else if( nb != par )
        {
            a.push_back(x);
            b.push_back(w);

            idx_b[w] = b.size() - 1;
            lamp = nb;

            return;
        }
    }
}

void dfs( int w, int par )
{
    used[w] = 1;
    parent[w] = par;
    int sz = v[w].size();
    for( int i = 0; i < sz; i ++ )
    {
        int nb = v[w][i].ver;
        if( used[nb] == 0 )
        {
            max_edge[nb] = max( max_edge[w] , v[w][i].prize );
            dfs(nb,par);
        }
    }
}


void make_tree( int i, int l, int r )
{
    if( l == r )
    {
        tree[i] = a[l];
        return;
    }

    int m = ( l + r ) / 2;
    make_tree(i*2,l,m);
    make_tree(i*2+1,m+1,r);

    tree[i] = max( tree[i*2] , tree[i*2+1] );
    return;
}

int query( int i, int l, int r, int ql, int qr )
{
    if( ql > qr ) return 0;

    if( ql == l && r == qr ) return tree[i];
    int m = ( l + r ) / 2;

    if( qr <= m ) return query(i*2,l,m,ql,qr);
    else if(  ql > m ) return query(i*2+1,m+1,r,ql,qr);
    else return max( query(i*2,l,m,ql,m) , query(i*2+1,m+1,r,m+1,qr) );
}

void solve()
{
    long long ans = 0;
    int sz = a.size();

    cin >> q;
    for( int i = 1; i <= q; i ++ )
    {
        int type,x,y;
        cin >> type >> x >> y;
        if( type == 1 )
        {
            x = idx[x];
            y = idx[y];

            //cout << x << " " << y << endl;

            int path1 = max( max_edge[x] , max_edge[y] );
            int path2 = max( max_edge[x] , max_edge[y] );

            //cout << path1 << endl;

            int idx1 = min( idx_b[parent[x]] , idx_b[parent[y]] );
            int idx2 = max( idx_b[parent[x]] , idx_b[parent[y]] );

            int e1 = query(1,0,sz-1,idx1+1,idx2);
            int e2 = max( query(1,0,sz-1,0,idx1) , query(1,0,sz-1,idx2+1,sz-1) );

            //cout << e1 << " " << e2 << endl;
            //cout << path1 << " " << path2 << endl;

            path1 = max( path1 , e1);
            path2 = max( path2 , e2 );

            //cout << ( max( path1,path2) * 2 ) + min(path1,path2) << endl;
            ans += ( max( path1,path2) * 2 ) + min(path1,path2);
        }
        else swap( idx[x] , idx[y] );
    }
    cout << ans << '\n';
}
void speed()
{
    ios_base::sync_with_stdio(false);
    cin.tie(NULL);
    cout.tie(NULL);
}
int main()
{
    speed();
    read();
    find_cycle(1,-1);
    int sz = a.size();

    memset(used,0,sizeof(used));
    for( int i = 0; i < sz; i ++ )
        used[b[i]] = 1;
    for( int i = 0; i < sz; i ++ )
        dfs(b[i],b[i]);

    make_tree(1,0,sz-1);

    /*
    cout << endl;
    for( int i = 0; i < sz; i ++ )
        cout << a[i] << " ";
    cout << endl;

    for( int i = 0; i < sz; i ++ )
        cout << b[i] << " ";
    cout << endl;
    cout << endl;

    for( int i = 1; i <= n; i ++ )
        cout << idx_b[i] << " ";
    cout << endl;

    for( int i = 1; i <= n; i ++ )
        cout << max_edge[i] << " ";
    cout << endl;

    for( int i = 1; i <= n; i ++ )
        cout << parent[i] << " ";
    cout << endl;
    cout << endl;
    */

    solve();
    return 0;
}
