#include <bits/stdc++.h>
using namespace std;

const int maxn = 3003;
const long long inf = 1e18;
int n, m, k;
long long int d[maxn];
bool used[maxn];
struct edge
{
    int ver;
    long long p;
    bool operator < (const edge&e)const
    {
        return (e.p < p);
    }
};
vector <edge> v[maxn];

void read()
{
    ios_base::sync_with_stdio(false);
    cin.tie(NULL);
    cout.tie(NULL);

    cin >> n >> m >> k;
    int i, x, y;
    long long t;
    for (i=1; i<=m; ++i)
    {
        cin >> x >> y >> t ;
        v[x].push_back({y,t});
        v[y].push_back({x,t});
    }
}

void Dijkstra(int s)
{
    d[s] = 0;
    priority_queue <edge> q;
    edge e = {s,0}, nb;
    q.push(e);

    while (!q.empty())
    {
        e = q.top(); q.pop();
        if (d[e.ver] >= e.p)
        {
            if (!used[e.ver])
            {
                used[e.ver] = true;
                int i, len = (int)(v[e.ver].size());
                for (i=0; i<len; ++i)
                {
                    nb = v[e.ver][i];
                    if (d[nb.ver] >= e.p + nb.p)
                    {
                        nb.p += e.p;
                        d[nb.ver] = nb.p;
                        q.push(nb);
                    }
                }
            }
        }
    }
}

void solve()
{
    for (int i=1; i<=n; ++i) d[i] = inf;
    Dijkstra(1);
    cout << d[n] << '\n' ;
}

int main()
{
    read();
    solve();
    return 0;
}