#include<bits/stdc++.h>
#define endl '\n'

using namespace std;

struct edge
{
    int v;
    long long d;
    edge() {}
    edge(int a, long long b)
    {
        v=a;
        d=b;
    }
};

bool operator<(edge p, edge q)
{
    return p.d>q.d;
}

int n, m;
long long k;
long long a[3005];
vector<edge> gr[3005];
vector<edge> gr2[3005];

bool used[3005];
long long dist[3005];
priority_queue<edge> pq;

void Dijkstra()
{
    memset(used, 0, sizeof(used));
    for(int i=2; i<=n; i++) dist[i]=2e18;
    pq.push(edge(1, 0));
    while(!pq.empty())
    {
        int tv=pq.top().v;
        long long td=pq.top().d;
        pq.pop();
        if(used[tv]) continue;
        used[tv]=1;
        int brs=gr2[tv].size();
        for(int i=0; i<brs; i++)
        {
            int nv=gr2[tv][i].v;
            long long dd=gr2[tv][i].d;
            if(dist[nv]<=td+dd) continue;
            dist[nv]=td+dd;
            pq.push(edge(nv, dist[nv]));
        }
    }
}

long long prob(int id)
{
    long long res=k*a[id];
    for(int i=1; i<=n; i++)
    {
        int brs=gr[i].size();
        for(int j=0; j<brs; j++)
        {
            gr2[i][j]=gr[i][j];
            gr2[i][j].d-=a[id];
            if(gr2[i][j].d<0) gr2[i][j].d=0;
        }
    }
    Dijkstra();
    return res+dist[n];
}

int main()
{
    ios::sync_with_stdio(0);
    cin.tie(0);
    cout.tie(0);

    cin>>n>>m>>k;
    for(int i=0; i<m; i++)
    {
        int v1, v2, d;
        cin>>v1>>v2>>d;
        gr[v1].push_back(edge(v2, d));
        gr[v2].push_back(edge(v1, d));
        gr2[v1].push_back(edge(v2, d));
        gr2[v2].push_back(edge(v1, d));
        a[i]=d;
    }
    long long bestans=2e18;
    for(int i=0; i<m; i++)
    {
        long long t=prob(i);
        if(t<bestans) bestans=t;
    }
    cout<<bestans<<endl;
    return 0;
}
