#include <algorithm>
#include <iostream>
#include <utility>
#include <vector>
#include <random>
#include <queue>
#define endl '\n'
using namespace std;

const int MAXN = 3000;

mt19937 rg(1242024);

int n, m, k;
long long sum[MAXN + 5][2];
int adj[MAXN + 5][MAXN + 5];
vector< pair<int, int> > G[MAXN + 5];
priority_queue<int> dp[MAXN + 5][2]; /// dp[i][j] - a set of the k maximum edges in the path from 1 to i with exactly j edges

int main()
{
    ios :: sync_with_stdio(false);
    cin.tie(NULL); cout.tie(NULL);

    cin >> n >> m >> k;

    for (int i = 1; i <= m; ++ i)
    {
        int u, v, w;
        cin >> u >> v >> w;
        adj[u][v] = adj[v][u] = w;
        G[u].push_back({v, w});
        G[v].push_back({u, w});
    }

    int c = 0;
    long long ans = (long long)(1e19);
    for (int j = 1; j <= max(n, m); ++ j)
    {
        for (int i = 1; i <= n; ++ i)
        {
            if (j == 1 and adj[1][i])
            {
                dp[i][c].push(-adj[1][i]);
                sum[i][c] = adj[1][i];
            }

            if (j > 1)
            {
                for (auto [p, w] : G[i])
                {
                    auto pq = dp[p][c ^ 1];
                    long long sum1 = sum[p][c ^ 1];
                    if (!pq.size()) continue;
                    pq.push(-w);
                    sum1 += w;
                    if (pq.size() > k)
                    {
                        sum1 += pq.top();
                        pq.pop();
                    }
                    if (!dp[i][c].size())
                    {
                        dp[i][c] = pq;
                        sum[i][c] = sum1;
                    }
                    else
                    {
                        if (sum1 <= sum[i][c])
                        {
                            dp[i][c] = pq;
                            sum[i][c] = sum1;
                        }
                    }
                }
            }
        }
        if (dp[n][c].size()) ans = min(ans, sum[n][c]);
        c ^= 1;
    }

    cout << ans << endl;

    return 0;
}
