#include <algorithm>
#include <iostream>
#include <utility>
#include <vector>
#define endl '\n'
using namespace std;

const int MAXN = 3000;

int n, m, k;
int adj[MAXN + 5][MAXN + 5];
vector< pair<int, int> > G[MAXN + 5];
vector<int> dp[MAXN + 5][2]; /// dp[i][j] - a set of the k maximum edges in the path from 1 to i with exactly j edges

long long sum(vector<int> v)
{
    long long ret = 0;
    for (auto x : v)
    {
        ret += x;
    }
    return ret;
}

int main()
{
    ios :: sync_with_stdio(false);
    cin.tie(NULL); cout.tie(NULL);

    cin >> n >> m >> k;

    for (int i = 1; i <= m; ++ i)
    {
        int u, v, w;
        cin >> u >> v >> w;
        adj[u][v] = adj[v][u] = w;
        G[u].push_back({v, w});
        G[v].push_back({u, w});
    }

    int c = 0;
    long long ans = (long long)(1e18);
    for (int j = 0; j < n; ++ j)
    {
        for (int i = 1; i <= n; ++ i)
        {
            dp[i][c].push_back(-1);

            if (j == 0 and i == 1) dp[i][c].pop_back();
            if (j == 1 and adj[1][i])
            {
                dp[i][c].pop_back();
                dp[i][c].push_back(adj[1][i]);
            }

            if (j > 1)
            {
                for (auto [s, w] : G[i])
                {
                    vector<int> v = dp[s][c ^ 1];
                    if (v[0] == -1) continue;
                    v.push_back(w);
                    if (v.size() > k)
                    {
                        sort(v.begin(), v.end());
                        reverse(v.begin(), v.end());
                        v.pop_back();
                    }
                    if (dp[i][c][0] == -1) dp[i][c] = v;
                    else if (sum(v) < sum(dp[i][c])) dp[i][c] = v;
                }
            }
            if (i == n and dp[i][c][0] != -1) ans = min(ans, sum(dp[i][c]));
        }
        c ^= 1;
    }

    cout << ans << endl;

    return 0;
}
