#include <algorithm>
#include <iostream>
#include <vector>
#define endl '\n'
using namespace std;

const int MAXN = 60;

int n, m, k;
int adj[MAXN + 5][MAXN + 5];
vector<int> dp[MAXN + 5][MAXN + 5]; /// dp[i][j] - a set of the k maximum edges in the path from 1 to i with exactly j edges

long long sum(vector<int> v)
{
    long long ret = 0;
    for (auto x : v)
    {
        ret += x;
    }
    return ret;
}

int main()
{
    ios :: sync_with_stdio(false);
    cin.tie(NULL); cout.tie(NULL);

    cin >> n >> m >> k;

    for (int i = 1; i <= m; ++ i)
    {
        int u, v, w;
        cin >> u >> v >> w;
        adj[u][v] = adj[v][u] = w;
    }

    for (int j = 0; j < n; ++ j)
    {
        for (int i = 1; i <= n; ++ i)
        {
            dp[i][j].push_back(-1);

            if (j == 0 and i == 1) dp[i][j].pop_back();
            if (j == 1 and adj[1][i])
            {
                    dp[i][j].pop_back();
                    dp[i][j].push_back(adj[1][i]);
            }

            if (j > 1)
            {
                for (int s = 1; s <= n; ++ s)
                {
                    if (adj[s][i])
                    {
                        vector<int> v = dp[s][j - 1];
                        if (v[0] == -1) continue;
                        v.push_back(adj[s][i]);
                        if (v.size() > k)
                        {
                            sort(v.begin(), v.end());
                            reverse(v.begin(), v.end());
                            v.pop_back();
                        }
                        if (dp[i][j][0] == -1) dp[i][j] = v;
                        else if (sum(v) < sum(dp[i][j])) dp[i][j] = v;
                    }
                }
            }
        }
    }

    long long ans = (long long)(1e18);
    for (int t = 0; t < n; ++ t)
    {
        if (dp[n][t][0] != -1)
        {
            ans = min(ans, sum(dp[n][t]));
        }
    }

    cout << ans << endl;

    return 0;
}
