#include <iostream>
#include <utility>
#include <vector>
#include <queue>
#define endl '\n'
using namespace std;

const int MAXN = 3000;

int n, m, k;
long long dist[MAXN + 5];
vector< pair<int, int> > G[MAXN + 5];

int main()
{
    ios :: sync_with_stdio(false);
    cin.tie(NULL); cout.tie(NULL);

    cin >> n >> m >> k;

    for (int i = 1; i <= m; ++ i)
    {
        int u, v, w;
        cin >> u >> v >> w;
        G[u].push_back({v, w});
        G[v].push_back({u, w});
    }

    for (int i = 1; i <= n; ++ i)
    {
        dist[i] = (long long)(1e18);
    }

    dist[1] = 0;
    priority_queue< pair<long long, int> > pq;
    pq.push({0, 1});

    while (!pq.empty())
    {
        int u = pq.top().second;
        long long d = -pq.top().first;
        pq.pop();
        if (d > dist[u]) continue;
        for (auto [v, w] : G[u])
        {
            if (d + w < dist[v])
            {
                dist[v] = d + w;
                pq.push({-dist[v], v});
            }
        }
    }

    cout << dist[n] << endl;

    return 0;
}
