#include <algorithm>
#include <iostream>
#include <utility>
#include <vector>
#define endl '\n'
using namespace std;

const int MAXN = 3000;

int n, m, k;
bool used[MAXN + 5];
vector<int> weights;
long long ans = (long long)(1e18);
vector< pair<int, int> > G[MAXN + 5];

void rec(int u)
{
    if (u == n)
    {
        sort(weights.begin(), weights.end());

        long long cost = 0;
        for (int i = weights.size() - 1; i >= max(0, (int)(weights.size()) - k); -- i)
        {
            cost += weights[i];
        }

        ans = min(ans, cost);

        return;
    }

    used[u] = true;
    for (auto [v, w] : G[u])
    {
        if (!used[v])
        {
            weights.push_back(w);
            rec(v);
            weights.pop_back();
        }
    }
    used[u] = false;
}

int main()
{
    ios :: sync_with_stdio(false);
    cin.tie(NULL); cout.tie(NULL);

    cin >> n >> m >> k;

    for (int i = 1; i <= m; ++ i)
    {
        int u, v, w;
        cin >> u >> v >> w;
        G[u].push_back({v, w});
        G[v].push_back({u, w});
    }

    rec(1);

    cout << ans << endl;

    return 0;
}
