#include <algorithm>
#include <iostream>
#include <utility>
#include <vector>
#define endl '\n'
using namespace std;

const int MAXN = 3000;

struct edge
{
    int u, v, w;

    edge(int u, int v, int w)
    {
        this -> u = u;
        this -> v = v;
        this -> w = w;
    }

    bool operator < (edge &other)
    {
        return (w < other.w);
    }
};

int n, m, k;
bool flag[MAXN + 5];
vector<int> weights;
int p[MAXN + 5], sz[MAXN + 5];
vector< pair<int, int> > G[MAXN + 5];

int comp(int u)
{
    if (p[u] == u) return u;
    return (p[u] = comp(p[u]));
}

void unite(int u, int v)
{
    u = comp(u);
    v = comp(v);
    if (sz[u] < sz[v]) swap(u, v);
    p[v] = u;
    sz[u] += sz[v];
}

void DFS(int u, int p)
{
    for (auto [v, w] : G[u])
    {
        if (v != p)
        {
            DFS(v, u);
            if (flag[v])
            {
                flag[u] = true;
                weights.push_back(w);
            }
        }
    }

}

int main()
{
    ios :: sync_with_stdio(false);
    cin.tie(NULL); cout.tie(NULL);

    cin >> n >> m >> k;

    for (int i = 1; i <= n; ++ i)
    {
        p[i] = i;
        sz[i] = 1;
    }

    vector<edge> edges;
    for (int i = 1; i <= m; ++ i)
    {
        int u, v, w;
        cin >> u >> v >> w;
        edges.emplace_back(u, v, w);
    }

    sort(edges.begin(), edges.end());

    for (auto e : edges)
    {
        if (comp(e.u) != comp(e.v))
        {
            unite(e.u, e.v);
            G[e.u].push_back({e.v, e.w});
            G[e.v].push_back({e.u, e.w});
        }
    }

    flag[n] = true;
    DFS(1, -1);

    sort(weights.begin(), weights.end());

    long long cost = 0;
    for (int i = weights.size() - 1; i >= max(0, (int)(weights.size()) - k); -- i)
    {
        cost += weights[i];
    }

    cout << cost << endl;

    return 0;
}
