#include <bits/stdc++.h>
#define endl '\n'
using namespace std;

const int MAXM = 3000 + 3;


int n, m, k;

struct Node
{
    int v;
    long long tg;
    Node () {};
    Node (int _v, long long _tg)
    {
        v = _v;;
        tg = _tg;;
    }
};
vector <Node> G[MAXM];

bool operator < (Node a, Node b)
{
    return a.tg > b.tg;
}

bool used[MAXM];
long long dist[MAXM];

long long answer = 1e8;
vector <int> v[MAXM];
int br = 1;

int path[MAXM];
int p2[MAXM];

void dfs(int s, int len = 0)
{
    if (s == n)
    {
        long long tmp = 0;

        for (int i = 0; i < len; i++)
        {
            p2[i] = path[i];
        }
        sort(p2, p2 + len, greater<int>());

        for (int i = 0; i < min(k, len); i++)
            tmp += p2[i];

        answer = min(answer, tmp);
        return;
    }

    used[s] = 1;

    for (int i = 0; i < G[s].size(); i++)
    {
        if (used[G[s][i].v]) continue;

        path[len] = G[s][i].tg;
        dfs(G[s][i].v, len + 1);
        path[len] = 0;
    }
}

int main()
{
    ios::sync_with_stdio(0);
    cin.tie(0);
    cout.tie(0);

    cin >> n >> m >> k;

    for (int i = 1; i <= m; i++)
    {
        int a, b;
        long long tg;
        cin >> a >> b >> tg;
        G[a].push_back(Node(b, tg));
        G[b].push_back(Node(a, tg));
    }

    for (int i = 2; i <= n; i++)
        dist[i] = 1e18;

    dfs(1);

    cout << answer << endl;

    return 0;
}
/**
6 7 3
1 2 2
2 3 2
3 4 2
4 5 8
5 1 1
5 6 7
4 6 3


*/
