#include <bits/stdc++.h>
#define endl '\n'
using namespace std;

const int MAXM = 3000 + 3;


int n, m, k;

struct Node
{
    int v;
    long long tg;
    Node () {};
    Node (int _v, long long _tg)
    {
        v = _v;;
        tg = _tg;;
    }
};
vector <Node> G[MAXM];

bool operator < (Node a, Node b)
{
    return a.tg > b.tg;
}

bool used[MAXM];
long long dist[MAXM];

int main()
{
    ios::sync_with_stdio(0);
    cin.tie(0);
    cout.tie(0);

    cin >> n >> m >> k;

    for (int i = 1; i <= m; i++)
    {
        int a, b;
        long long tg;
        cin >> a >> b >> tg;
        G[a].push_back(Node(b, tg));
        G[b].push_back(Node(a, tg));
    }

    for (int i = 2; i <= n; i++)
        dist[i] = 2e9;

    priority_queue <Node> pq;

    pq.push(Node(1, 0));

    while (!pq.empty())
    {
        int v = pq.top().v;
        int tg = pq.top().tg;

        pq.pop();
        if (used[v]) continue;
        used[v] = 1;

        for (int i = 0; i < G[v].size(); i++)
        {
            if (dist[v] + G[v][i].tg < dist[G[v][i].v])
            {
                dist[G[v][i].v] = dist[v] + G[v][i].tg;
                pq.push(Node(G[v][i].v, dist[G[v][i].v]));
            }
        }
    }

    cout << dist[n] << endl;

    return 0;
}
/**
6 7 3
1 2 2
2 3 2
3 4 2
4 5 8
5 1 1
5 6 7
4 6 3


*/
