#include <bits/stdc++.h>
#define endl '\n'

using namespace std;
typedef long long ll;

void speed()
{
    ios_base::sync_with_stdio(false);
    cin.tie(NULL);
    cout.tie(NULL);
}

const int maxn = 2e5 + 10;

int n, used[maxn], fr[maxn], bk[maxn];
vector < pair < int, ll > > g[maxn], cycle;
bool found = false;
void find_cycle(int v, int p)
{

    used[v] = 1;
    for (pair < int, ll > nb : g[v])
    {
        if (found)
        return;
        if (nb.first == p)
            continue;

        if (!used[nb.first])
        {
            bk[nb.first] = nb.second;
            fr[nb.first] = v;
            find_cycle(nb.first, v);
        }
        else
        {
            int cur = v;
            while(cur != nb.first)
            {
                cycle.push_back({cur, bk[cur]});
                cur = fr[cur];
            }
            cycle.push_back(nb);
            found = true;
            return;
        }
    }
}

int up_to[maxn];
ll mx[maxn];
void go_down(int v, int p, int to)
{
    up_to[v] = to;
    for (pair < int, ll > nb : g[v])
    {
        if (nb.first == p || used[nb.first] == 1)
            continue;
        mx[nb.first] = max(mx[v], nb.second);
        go_down(nb.first, v, to);
    }
}

const int maxlog = 22;
int lg[maxn], dp[maxlog][maxn], ridx[maxn];

void build_sparse_table()
{
    int dm = cycle.size();
    for (int i = 1; i <= dm; i ++)
    {
        lg[i] = lg[i / 2] + 1;
        dp[0][i] = cycle[i - 1].second;
    }

    for (int j = 1; j < lg[dm]; j ++)
    {
        for (int i = 1; i <= dm - (1 << j) + 1; i ++)
        {
            dp[j][i] = dp[j - 1][i];
            if (dp[j - 1][i + (1 << (j - 1))] > dp[j][i])
            {
                dp[j][i] = dp[j - 1][i + (1 << (j - 1))];
            }
        }
    }

    /**for (int j = 0; j < lg[dm]; j ++, cout << endl)
        for (int i = 1; i <= dm; i ++)
        cout << dp[j][i] << " ";*/

}

ll query(int l, int r)
{
    l ++;
    r ++;
    int len = lg[r - l + 1] - 1;
    return  max(dp[len][l], dp[len][r - (1 << len) + 1]);
}

int q;
void solve()
{
    cin >> n;
    for (int i = 1; i <= n; i ++)
    {
        int v, u, w;
        cin >> v >> u >> w;
        g[v].push_back({u, w});
        g[u].push_back({v, w});
    }

    find_cycle(1, -1);

    memset(used, 0, sizeof(used));

    for (int i = 0; i < cycle.size(); i ++)
    {
        used[cycle[i].first] = 1;
    }

    for (int i = 0; i < cycle.size(); i ++)
    {
        go_down(cycle[i].first, - 1, i);
    }


    build_sparse_table();
    for (int i = 1; i <= n; i ++)
        ridx[i] = i;

    cin >> q;
    ll ans = 0;
    for (int i = 1; i <= q; i ++)
    {
        int t, v, u;
        cin >> t >> v >> u;
        if (t == 1)
        {
            v = ridx[v];
            u = ridx[u];
            ll p1 = mx[v], p2 = mx[u];
            v = up_to[v];
            u = up_to[u];
            if (v > u)
                swap(v, u);

            ll d1 = 0, d2 = 0;
            d1 = query(v, u - 1);
            if (v != 0)
                d2 = query(0, v - 1);
            d2 = max(d2, query(u, cycle.size() - 1));

            d1 = max(max(p1, p2), d1);
            d2 = max(max(p1, p2), d2);

            if (d1 < d2)
                swap(d1, d2);
                ///cout << v << " :: " << u << endl;
               /// cout << query(v, u - 1) << " " << query(u, cycle.size() - 1) << endl;
            ///cout << d1 << " -- " << d2 << endl;
            ll cur = d1 * 2 + d2;
            ans = ans + cur;
        }
        else
        {
            swap(ridx[v], ridx[u]);
        }
    }

    cout << ans << endl;
}

int main()
{
    speed();
    solve();
	return 0;
}
