#pragma O3

#include <stdio.h>
#include <stdlib.h>
#include <stdint.h>
#include <queue>

#define MAX_N 4000

struct Edge {
	int32_t from;
	int32_t to;
	int64_t cost;
	int32_t next;
};

Edge edges[2 * MAX_N];
int64_t edges_len = 1;
int32_t first_edge[MAX_N];

void make_edge(int32_t from, int32_t to, int64_t cost) {
	edges[edges_len] = {
		.from = from,
		.to   = to,
		.cost = cost,
		.next = first_edge[from],
	};
	first_edge[from] = edges_len;
	edges_len += 1;
}

int32_t n, m, k;

struct Queued {
	int32_t cost;
	int32_t node;
	std::priority_queue<int32_t, std::vector<int32_t>, std::greater<int32_t>> kmax;
};

bool operator<(Queued a, Queued b) {
	return a.cost > b.cost;	
}

bool vis[MAX_N];
int32_t dijkstra() {
	std::priority_queue<Queued> queue;
	
	{
		Queued q;
		q.cost = 0;
		q.node = 1;
		queue.push(q);
	}
	
	
	while (!queue.empty()) {
		Queued cur = queue.top();
		queue.pop();
			
		if (vis[cur.node]) continue;
		vis[cur.node] = true;

		if (cur.node == n) return cur.cost;		

		for (int i = first_edge[cur.node]; i; i = edges[i].next) {
			Queued q;
			
			q.node = edges[i].to;
			q.kmax = cur.kmax;
			q.cost = cur.cost;
			
			q.cost += edges[i].cost;
			q.kmax.push(edges[i].cost);
			
			if (q.kmax.size() > k) {
				q.cost -= q.kmax.top();
				q.kmax.pop();
			}
			
			queue.push(q);
		}
	}
	
	return -1;
}

int main() {
	scanf("%d%d%d", &n, &m, &k);
	
	k=m;
	
	for (int32_t i = 1; i <= m; i += 1) {
		int32_t v1;
		int32_t v2;
		int64_t cost;
		
		scanf("%d%d%lld", &v1, &v2, &cost);
		
		make_edge(v1, v2, cost);
		make_edge(v2, v1, cost);
	}
	
	printf("%d\n", dijkstra());
}
/*
6 7 3
1 2 2
2 3 2
3 4 2
4 5 8
5 1 1
5 6 7
4 6 3
*/