#pragma O3

#include <stdio.h>
#include <stdlib.h>
#include <stdint.h>
#include <utility>
#include <algorithm>
#include <stack>

#define MAX_N 200005

struct Edge {
	int32_t from;
	int32_t to;
	int64_t cost;
	int32_t next;
};

Edge edges[2 * MAX_N + 2];
int64_t edges_len = 1;
int32_t first_edge[MAX_N];

int32_t n;

int64_t tree_max[MAX_N];

int32_t node_cycle_edge[MAX_N];

int64_t cycle_r_max[MAX_N][20];

Edge cycle_edges[MAX_N];
int32_t cycle_edges_len = 0;

int64_t get_cycle_r_max(int32_t a, int32_t b) {
	int64_t max = 0;
	
	int32_t sublen = (b - a + cycle_edges_len) % cycle_edges_len;
	
	for (int i = 0; 1 << i <= sublen; i += 1) {
		if (!(sublen & (1 << i))) continue;
		
		max = std::max(max, cycle_r_max[a][i]);
		a += 1 << i;
		a %= cycle_edges_len;
	}
	return max;
}

void make_edge(int32_t from, int32_t to, int64_t cost) {
	edges[edges_len] = {
		.from = from,
		.to   = to,
		.cost = cost,
		.next = first_edge[from],
	};
	first_edge[from] = edges_len;
	edges_len += 1;
}

void calc_tree(Edge edge) {
	tree_max       [edge.to] = std::max(tree_max[edge.from], edge.cost);
	node_cycle_edge[edge.to] = node_cycle_edge[edge.from];
	for (int32_t i = first_edge[edge.to]; i; i = edges[i].next) {
		if (edges[i].to == edge.from) continue;
		calc_tree(edges[i]);
	}
}

int64_t get_ans(int32_t v1, int32_t v2) {
	int64_t r_max = std::max(
		std::max(tree_max[v1], tree_max[v2]),
		get_cycle_r_max(node_cycle_edge[v1], node_cycle_edge[v2])
	);

	int64_t l_max = std::max(
		std::max(tree_max[v1], tree_max[v2]),
		get_cycle_r_max(node_cycle_edge[v2], node_cycle_edge[v1])
	);

	return 2 * std::max(r_max, l_max) + std::min(r_max, l_max);
}

bool vis[MAX_N];

std::stack<Edge> trace;

bool dfs(Edge cur) {
	trace.push(cur);
	
	if (vis[cur.to]) return true;
	vis[cur.to] = true;

	for (int32_t i = first_edge[cur.to]; i; i = edges[i].next) {
		if (edges[i].to == cur.from) continue;
		if (dfs(edges[i])) return true;
	}
	
	trace.pop();
	
	return false;
}

void find_cycle() {
	dfs({.from = 0, .to = 1, .cost = 0, .next = 0});
		
	int32_t cycle_link = trace.top().to;
	do {
		Edge cur = trace.top();

		cycle_edges[cycle_edges_len] = cur;
		cycle_edges_len += 1;

		trace.pop();
	} while (trace.top().to != cycle_link);

	for (int32_t i = 0; i < cycle_edges_len; i += 1) {
		node_cycle_edge[cycle_edges[i].from] = i;

		for (int32_t j = first_edge[cycle_edges[i].from]; j; j = edges[j].next) {
			if (edges[j].to == cycle_edges[i].to) continue;
			if (edges[j].to == cycle_edges[(i+1) % cycle_edges_len].from) continue;
			calc_tree(edges[j]);
		}
	}
	
	for (int32_t i = 0; i < cycle_edges_len; i += 1) {
		cycle_r_max[i][0] = cycle_edges[(i+1) % cycle_edges_len].cost;
	}
	
	for (int32_t i = 1; i < 20; i += 1) {
		for (int32_t j = 0; j < cycle_edges_len; j += 1) {
			cycle_r_max[j][i] = std::max(cycle_r_max[j][i-1], cycle_r_max[(j + (1 << (i-1))) % cycle_edges_len][i-1]);
		}
	}
}

int main() {
    scanf("%d", &n);
	
	for (int32_t i = 1; i <= n; i += 1) {
		int32_t v1;
		int32_t v2;
		int64_t cost;
		
		scanf("%d%d%lld", &v1, &v2, &cost);
		
		make_edge(v1, v2, cost);
		make_edge(v2, v1, cost);
	}
	
	find_cycle();
	
	int32_t q;
	scanf("%d", &q);
	
	int32_t node_alias[MAX_N];
	for (int32_t i = 1; i <= n; i += 1) node_alias[i] = i;
	
	int64_t ans = 0;
	
	for (int32_t i = 0; i < q; i += 1) {
		int32_t t, v1, v2;
		scanf("%d%d%d", &t, &v1, &v2);

		if (t == 2) {
			std::swap(node_alias[v1], node_alias[v2]);
			continue;
		}
		
		v1 = node_alias[v1];
		v2 = node_alias[v2];

		ans += get_ans(v1, v2);
	}
	
	printf("%lld\n", ans);
}
/*
9
1 2 1
2 3 3
3 4 5
4 1 7
2 5 1
2 6 8
5 7 4
5 8 2
4 9 6
9
1 1 2
1 5 9
1 7 3
1 8 1
1 6 9
2 1 3
1 8 1
2 1 4
1 8 1
*/