#include <iostream>
#include <vector>
#include <climits>
#define MAX_N 3003
using namespace std;

vector <vector<int>> graf;
int table[MAX_N][MAX_N];
int minDistance[MAX_N];
bool used[MAX_N];

void deikstra(int s, int t, int n)
{
    long long currmin;
    int index;
    long long currd;
    fill_n(minDistance, n+1, INT_MAX);
    for(int i=0; i<graf[s].size(); i++)
    {
        minDistance[graf[s][i]]=table[s][graf[s][i]];
    }
    used[s]=true;
    while(true)
    {
        currmin=LONG_MAX;
        index=-1;
        for(int i=1; i<=n; i++)
        {
            if(!used[i] && minDistance[i]!=INT_MAX && minDistance[i]<currmin && i!=t)
            {
                index=i;
                currmin=minDistance[i];
            }
        }
        if(index==-1)
        {
            break;
        }
        used[index]=true;
        for(int i=0; i<graf[index].size(); i++)
        {
            currd=table[index][graf[index][i]]+currmin;
            if(minDistance[graf[index][i]]>currd && !used[graf[index][i]])
            {
                minDistance[graf[index][i]]=currd;
            }
        }
    }
}



int main()
{
    int n, m, k;
    cin >> n >> m >> k;
    int a, b, d;

    graf.resize(n+1);

    for(int i=0; i<m; i++)
    {
        cin >> a >> b >> d;
        graf[a].push_back(b);
        graf[b].push_back(a);
        table[a][b]=d;
        table[b][a]=d;
    }


    deikstra(1, n, n);
    /*for(int i=1; i<=n; i++)
    {
        cout << minDistance[i] << " ";
    }*/


    cout << minDistance[n];









    return 0;
}
