#include <iostream>
#include <vector>
#include <queue>
#include <climits>
#define MAX_N 3003
using namespace std;

int table[MAX_N][MAX_N];
vector <vector<int>> graf;
int minDistance[MAX_N];

void bfs(int s, int t)
{
    queue <int> opashka;
    opashka.push(s);
    int k;
    minDistance[s]=0;
    int currd;
    while(!opashka.empty())
    {
        k=opashka.front();
        opashka.pop();
        for(int i=0; i<graf[k].size(); i++)
        {
            currd=max(table[k][graf[k][i]], minDistance[k]);
            if(minDistance[graf[k][i]]>currd)
            {
                minDistance[graf[k][i]]=currd;
                if(graf[k][i]!=t)
                {
                    opashka.push(graf[k][i]);
                }
            }
        }
    }

}


int main()
{
    ios_base::sync_with_stdio(false);
    int n, m, k;
    cin >> n >> m >> k;
    int a, b, d;

    graf.resize(n+1);

    for(int i=0; i<m; i++)
    {
        cin >> a >> b >> d;
        graf[a].push_back(b);
        graf[b].push_back(a);
        table[a][b]=d;
        table[b][a]=d;
    }

    fill_n(minDistance, n+1, INT_MAX);

    bfs(1, n);
    /*for(int i=1; i<=n; i++)
    {
        cout << minDistance[i] << " ";
    }*/
    cout << minDistance[n];




    return 0;
}
