#include <iostream>
#include <queue>
#include <set>
#include <algorithm>

#define endl '\n'

using namespace std;

struct Edge
{
    int to;
    int64_t price;

    Edge()
    {
        to = -1;
        price = 0;
    }

    Edge(int _to, int64_t _price)
    {
        to = _to;
        price = _price;
    }
};

const int MAXN = 3e3 + 3;

vector<Edge> graph[MAXN];
int64_t dist[MAXN];
multiset<int> most_expensive[MAXN];
bool in_queue[MAXN];

int main()
{
    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    int n, m, k;
    cin >> n >> m >> k;

    for (int i = 0; i < m; ++i)
    {
        int from, to;
        int64_t price;
        cin >> from >> to >> price;

        --from;
        --to;

        graph[from].push_back(Edge(to, price));
        graph[to].push_back(Edge(from, price));
    }

    for (int i = 0; i < n; ++i) {
        dist[i] = -1;
        most_expensive[i].clear();
    }

    queue<int> spfa;
    spfa.push(0);

    in_queue[0] = true;
    dist[0] = 0;

    while(!spfa.empty())
    {
        int currv = spfa.front();
        spfa.pop();
        in_queue[currv] = false;

        for (Edge& nextv : graph[currv]) {
            if (dist[nextv.to] == -1 or dist[currv] + nextv.price < dist[nextv.price])
            {
                dist[nextv.to] = dist[currv] + nextv.price;
                if (!in_queue[nextv.to])
                {
                    spfa.push(nextv.to);
                    in_queue[nextv.to] = true;
                }
            }
        }
    }

    cout << dist[n - 1] << endl;
}
