#include <iostream>
#include <queue>
#include <set>
#include <algorithm>

#define endl '\n'

using namespace std;

struct Edge
{
    int to, price;

    Edge()
    {
        to = -1;
        price = 0;
    }

    Edge(int _to, int _price)
    {
        to = _to;
        price = _price;
    }
};

const int MAXN = 3e3 + 3;

vector<Edge> graph[MAXN];
int64_t dist[MAXN];
multiset<int> most_expensive[MAXN];
bool in_queue[MAXN];

int main()
{
    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    int n, m, k;
    cin >> n >> m >> k;

    for (int i = 0; i < m; ++i)
    {
        int from, to, price;
        cin >> from >> to >> price;

        --from;
        --to;

        graph[from].push_back(Edge(to, price));
        graph[to].push_back(Edge(from, price));
    }

    for (int i = 0; i < n; ++i) {
        dist[i] = -1;
        most_expensive[i].clear();
    }

    queue<int> spfa;
    spfa.push(0);

    in_queue[0] = true;
    dist[0] = 0;

    while(!spfa.empty())
    {
        int currv = spfa.front();
        spfa.pop();
        in_queue[currv] = false;

        for (Edge& nextv : graph[currv]) {
            bool made_change = false;

            if (dist[nextv.to] == -1)
            {
                most_expensive[nextv.to] = most_expensive[currv];
                dist[nextv.to] = dist[currv];

                if ((int) most_expensive[nextv.to].size() == k)
                {
                    auto it = most_expensive[nextv.to].lower_bound(nextv.price);

                    if (it != most_expensive[nextv.to].begin())
                    {
                        if (*it == nextv.price)
                        {
                            --it;
                        }

                        it = most_expensive[nextv.to].begin();
                        dist[nextv.to] -= *it;
                        most_expensive[nextv.to].erase(it);

                        dist[nextv.to] += nextv.price;
                        most_expensive[nextv.to].insert(nextv.price);
                    }
                }
                else
                {
                    dist[nextv.to] += nextv.price;
                    most_expensive[nextv.to].insert(nextv.price);
                }

                made_change = true;
            }
            else if ((int) most_expensive[currv].size() < k)
            {
                if (dist[currv] + nextv.price < dist[nextv.to])
                {
                    dist[nextv.to] = dist[currv] + nextv.price;
                    most_expensive[nextv.to] = most_expensive[currv];
                    most_expensive[nextv.to].insert(nextv.price);

                    made_change = true;
                }
            }
            else
            {
                auto it = most_expensive[currv].lower_bound(nextv.price);

                if (it != most_expensive[currv].begin())
                {
                    if (*it == nextv.price)
                    {
                        --it;
                    }

                    int new_dist = dist[currv] - *it + nextv.price;
                    if (new_dist < dist[nextv.to])
                    {
                        dist[nextv.to] = new_dist;

                        most_expensive[nextv.to] = most_expensive[currv];
                        auto it2 = most_expensive[nextv.to].lower_bound(*it);
                        most_expensive[nextv.to].erase(it2);
                        most_expensive[nextv.to].insert(nextv.price);

                        made_change = true;
                    }
                }
            }

            if (made_change)
            {
                if (!in_queue[nextv.to])
                {
                    spfa.push(nextv.to);
                    in_queue[nextv.to] = true;
                }
            }
        }
    }

    cout << dist[n - 1] << endl;
}
