#include <bits/stdc++.h>

using namespace std;

typedef long long ll;

const ll Size=3e3+10,p=1e9+1;
ll n,k,start=0;
vector<pair<ll,ll>> adj[Size];
vector<ll> loop_size;
bool visited[Size],is_loop[Size];
ll neigh[Size],dist_to_loop[Size],parent[Size],loop_prefix[Size];
unordered_map<ll,ll> id_2_pos, ori_2_curr;

void leaf_rem(){
    queue<ll> to_do;
    for(ll i=1;i<=n;i++){
        if(neigh[i]==1){
            to_do.push(i);
            is_loop[i]=1;
        }
    }
    while(!to_do.empty()){
        ll curr=to_do.front();
        to_do.pop();
        for(ll i=0;i<adj[curr].size();i++){
            ll next=adj[curr][i].first;
            neigh[next]--;
            if(neigh[next]==1 and !is_loop[next]){
                to_do.push(next);
                is_loop[next]=1;
            }
        }
    }
}

void calc_dist(){
    queue<ll> to_do;
    for(ll i=1;i<=n;i++){
        if(!is_loop[i]){
            to_do.push(i);
            visited[i]=1;
            parent[i]=i;
        }
    }
    while(!to_do.empty()){
        ll curr=to_do.front();
        to_do.pop();
        for(ll i=0;i<adj[curr].size();i++){
            pair<ll,ll> next=adj[curr][i];
            if(!visited[next.first]){
                to_do.push(next.first);
                dist_to_loop[next.first]=dist_to_loop[curr]+next.second;
                parent[next.first]=parent[curr];
                visited[next.first]=1;
            }
        }
    }
}

void calc_loop(){
    ll curr=0;
    for(ll i=1;i<=n;i++){
        if(!is_loop[i]){
            curr=i;
            start=i;
            break;
        }
    }
    while(true){
        visited[curr]=1;
        bool has_found=0;
        for(ll i=0;i<adj[curr].size();i++){
            ll next=adj[curr][i].first;
            if(!visited[next] and !is_loop[next]){
                id_2_pos[next]=loop_size.size()+1;
                loop_size.push_back(adj[curr][i].second);
                has_found=1;
                curr=next;
                break;
            }
        }
        if(!has_found){
            for(ll i=0;i<adj[curr].size();i++){
                ll next=adj[curr][i].first;
                if(next==start){
                    id_2_pos[next]=loop_size.size()+1;
                    loop_size.push_back(adj[curr][i].second);
                    break;
                }
            }
            break;
        }
    }
    loop_prefix[0]=loop_size[0];
    for(ll i=1;i<loop_size.size();i++){
        loop_prefix[i]=loop_prefix[i-1]+loop_size[i];
    }
}

ll find_total_dist(ll from,ll to){
    ll true_from=ori_2_curr[from];
    ll true_to=ori_2_curr[to];
    ll id_to=id_2_pos[parent[true_to]],id_from=id_2_pos[parent[true_from]];
    ll min_id=min(id_from,id_to);
    ll max_id=max(id_from,id_to);
    ll p1=dist_to_loop[true_from]+loop_prefix[max_id]-loop_prefix[min_id]+dist_to_loop[true_to];
    ll p2=dist_to_loop[true_from]+loop_prefix[loop_size.size()-1]-(loop_prefix[max_id]-loop_prefix[min_id])+dist_to_loop[true_to];
    return max(p1,p2)*2+min(p1,p2);
}

int main(){
    ios_base::sync_with_stdio(0);
    cin.tie(0);
    cin>>n;
    for(ll i=0;i<n;i++){
        ll from,to,len;
        cin>>from>>to>>len;
        adj[from].push_back({to,len});
        adj[to].push_back({from,len});
        neigh[from]++;
        neigh[to]++;
    }
    leaf_rem();
    /*
    for(ll i=1;i<=n;i++){
        cout<<is_loop[i]<<endl;
    }
    */
    calc_dist();
    /*
    for(ll i=1;i<=n;i++){
        cout<<parent[i]<<" "<<dist_to_loop[i]<<endl;
    }
    */
    for(ll i=1;i<=n;i++){
        visited[i]=0;
        ori_2_curr[i]=i;
    }
    calc_loop();
    /*
    for(ll i=0;i<loop_size.size();i++){
        cout<<loop_size[i]<<endl;
    }
    cout<<endl;
    for(ll i=0;i<loop_size.size();i++){
        cout<<loop_prefix[i]<<endl;
    }
    cout<<endl;
    for(ll i=1;i<=n;i++){
        cout<<id_2_pos[i]<<endl;
    }
    */
    ll q,tot=0;
    cin>>q;
    while(q--){
        ll t=0;
        cin>>t;
        if(t==1){
            ll from,to;
            cin>>from>>to;
            ll ans=find_total_dist(from,to);
            tot+=ans;
        }
        if(t==2){
            ll a,b;
            cin>>a>>b;
            ori_2_curr[a]=b;
            ori_2_curr[b]=a;
        }
    }
    cout<<tot<<endl;
    return 0;
}
/*
9
1 2 1
2 3 3
3 4 5
4 1 7
2 5 1
2 6 8
5 7 4
5 8 2
4 9 6
9
1 1 2
1 5 9
1 7 3
1 8 1
1 6 9
2 1 3
1 8 1
2 1 4
1 8 1
*/
