#include <iostream>
#include <algorithm>
#include <vector>
#include <queue>
using namespace std;
const int MAXN=3e3+10;
vector <pair <int,long long> > v[MAXN];
vector <long long> path[MAXN];
priority_queue <pair <long long,int> > q;
long long dp[MAXN], pr[MAXN][MAXN];
int n, k;
void prefix(int ind) {
    for (int i=0;i<path[ind].size();i++) {
        if (i==0) pr[ind][i]=path[ind][i];
        else pr[ind][i]=pr[ind][i-1]+path[ind][i];
    }
}
long long f(int ind, long long c) {
    if (path[ind].empty()) return c;
    if (path[ind].size()<k) return pr[ind][path[ind].size()-1]+c;
    if (c>path[ind][k-1]) {
        if (k==1) return c;
        return pr[ind][k-2]+c;
    } else return pr[ind][k-1]+c;
}
void dejkstra(int start) {
    dp[start]=0;
    q.push({0,start});
    while (!q.empty()) {
        int x=q.top().second;
        q.pop();
        for (auto i:v[x]) {
            if (dp[i.first]==-1 || dp[i.first]>f(x,i.second)) {
                if (!path[i.first].empty()) path[i.first].clear();
                int ss=min(k,(int)path[x].size()), j=0;
                for (j=0;j<ss && path[x][j]>i.second;j++) path[i.first].push_back(path[x][j]);
                if (j<k) path[i.first].push_back(i.second);
                if (ss<k) ss++;
                for (;j+1<ss;j++) path[i.first].push_back(path[x][j]);
                prefix(i.first);
                dp[i.first]=pr[i.first][min(k,(int)path[i.first].size())-1];
                q.push({-dp[i.first],i.first});
            }
        }
    }
}
int main () {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);
    cout.tie(nullptr);
    int m, x, y, c;
    cin >> n >> m >> k;
    for (int i=0;i<m;i++) {
        cin >> x >> y >> c;
        v[x].push_back({y,c});
        v[y].push_back({x,c});
    }
    for (int i=1;i<=n;i++) dp[i]=-1;
    dejkstra(1);
    cout << dp[n] << endl;
    return 0;
}
/**
6 7 1
1 2 2
2 3 2
3 4 2
4 5 8
5 1 1
5 6 7
4 6 3
**/

