#include <iostream>
#include <algorithm>
#include <vector>
#include <queue>
using namespace std;
const int MAXN=3e3+10;
struct Edge {
    int x, y;
};
Edge ed[MAXN];
vector <pair <int,int> > v[MAXN];
vector <int> path[MAXN];
priority_queue <pair <int,int> > q;
int dp[MAXN];
bool t[MAXN][MAXN], used[MAXN];
void dejkstra(int start) {
    dp[start]=0;
    q.push({0,start});
    while (!q.empty()) {
        int x=q.top().second;
        q.pop();
        for (auto i:v[x]) {
            if (dp[i.first]<max(dp[x],i.second)) {
                dp[i.first]=max(dp[x],i.second);
                q.push({-dp[i.first],i.first});
            }
        }
    }
}
void dfs(int x) {
    used[x]=true;
    for (auto i:v[x]) {
        if (used[i.first] || !t[x][i.first]) continue;
        for (auto j:path[x]) path[i.first].push_back(j);
        path[i.first].push_back(-i.second);
        dfs(i.first);
    }
}
int main () {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);
    cout.tie(nullptr);
    int n, m, k, x, y, c;
    cin >> n >> m >> k;
    for (int i=0;i<m;i++) {
        cin >> x >> y >> c;
        v[x].push_back({y,c});
        v[y].push_back({x,c});
        ed[i].x=x; ed[i].y=y;
    }
    if (k==1) {
        dejkstra(1);
        cout << dp[n] << endl;
        return 0;
    }
    int ans=-1;
    for (int mask=0;mask<(1<<m);mask++) {
        int kopie=mask;
        for (int i=0;i<m;i++) {
            if (mask%2==1) t[ed[i].x][ed[i].y]=t[ed[i].y][ed[i].x]=true;
            else t[ed[i].x][ed[i].y]=t[ed[i].y][ed[i].x]=false;
            mask/=2;
        }
        mask=kopie;
        for (int i=1;i<=n;i++) {
            if (!path[i].empty()) path[i].clear();
            used[i]=false;
        }
        dfs(1);
        if (!used[n]) continue;
        sort(path[n].begin(),path[n].end());
        int s=0;
        for (int i=0;i<min(k,(int)path[n].size());i++) s-=path[n][i];
        if (ans==-1) ans=s;
        else ans=min(ans,s);
    }
    cout << ans << endl;
    return 0;
}
/**
6 7 3
1 2 2
2 3 2
3 4 2
4 5 8
5 1 1
5 6 7
4 6 3
**/
