#include <iostream>
#include <vector>
using namespace std;
const long long MAXN=2e5+10;
vector <pair <long long, long long> > v[MAXN];
pair <long long, long long> pr[MAXN], arc[2*MAXN];
long long indc[MAXN], up[MAXN], sp[2*MAXN][20], stepen[2*MAXN], fath[MAXN];
long long before[MAXN];
bool used[MAXN], cycle[MAXN], found;
long long n, br, s1, s2;
void dfs_cycle(long long x, long long par) {
    used[x]=true;
    for (auto i:v[x]) {
        if (found) break;
        if (i.first==par) continue;
        if (used[i.first]) {
            found=true;
            pr[i.first]={x,i.second};
            break;
        }
        dfs_cycle(i.first,x);
        if (found) pr[i.first]={x,i.second};
    }
}
void find_cycle() {
    for (long long i=1;i<=n;i++) {
        if (pr[i].first==-1) continue;
        long long j=i;
        br=0;
        while (i!=j || br==0) {
            cycle[i]=true;
            arc[br]={i,pr[i].second};
            indc[i]=br;
            br++;
            i=pr[i].first;
        }
        break;
    }
}
void dfs_tree(long long x, long long par) {
    if (par==-1) up[x]=0;
    for (auto i:v[x]) {
        if (i.first==par || cycle[i.first]) continue;
        up[i.first]=max(up[i.first],i.second);
        fath[i.first]=fath[x];
        dfs_tree(i.first,x);
    }
}
void sparce_table() {
    for (long long j=1;(1<<j)<=2*br;j++) {
        long long st=(1<<j);
        for (long long i=0;i+st-1<2*br;i++) {
            sp[i][j]=max(sp[i][j-1],sp[i+st/2-1][j-1]);
        }
    }
}
long long find_interval(long long l, long long r) {
    long long st=stepen[r-l+1];
    return max(sp[l][st],sp[r-(1<<st)+1][st]);
}
void path(long long x, long long y) {
    long long s=max(up[x],up[y]);
    x=fath[x]; y=fath[y];
    if (indc[x]>indc[y]) swap(x,y);
    s1=s2=s;
    s1=max(s1,find_interval(indc[x],indc[y]-1));
    s2=max(s2,find_interval(indc[y],indc[x]+br-1));
    ///cout << s1 << ' ' << s2 << endl;
    if (s1<s2) swap(s1,s2);
}
int main () {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);
    cout.tie(nullptr);
    long long x, y, c;
    cin >> n;
    for (long long i=0;i<n;i++) {
        cin >> x >> y >> c;
        v[x].push_back({y,c});
        v[y].push_back({x,c});
        pr[i+1].first=-1;
        before[i+1]=i+1;
    }
    dfs_cycle(1,-1);
    find_cycle();
    for (long long i=0;i<br;i++) {
        fath[arc[i].first]=arc[i].first;
        dfs_tree(arc[i].first,-1);
    }
    for (long long i=0;i<br;i++) {
        arc[i+br]=arc[i];
        sp[i][0]=sp[i+br][0]=arc[i].second;
    }
    stepen[1]=0;
    for (long long i=2;i<=2*br;i++) {
        stepen[i]=stepen[i-1];
        if ((1<<(stepen[i]+1))<i) stepen[i]++;
    }
    sparce_table();
    long long q, type;
    long long ans=0;
    cin >> q;
    for (long long i=0;i<q;i++) {
        cin >> type >> x >> y;
        if (type==1) {
            x=before[x]; y=before[y];
            path(x,y);
            ans+=s1*2+s2;
        } else {
            swap(before[x],before[y]);
        }
    }
    cout << ans << endl;
    return 0;
}
