#include <algorithm>
#include <iostream>
#include <numeric>
#include <cassert>
#include <cstring>
#include <vector>
#include <queue>

typedef long long llong;
const int MAXN = 3000 + 10;
const llong INF  = 1e9;

int n, m, k;
int dist[MAXN];
bool vis[MAXN];
std::vector <std::pair <int,int>> g[MAXN];
std::priority_queue <std::pair <int,int>> pq;

void solve()
{
    std::fill(dist + 1, dist + 1 + n, INF);
    dist[1] = 0;
    pq.emplace(0, 1);
    while (!pq.empty())
    {
        auto [currDist, top] = pq.top();
        pq.pop();
        if (top == n) break;
        if (vis[top]) continue;
        vis[top] = true;

        for (const auto &[y, ed] : g[top])
        {
            if (dist[y] > std::max(dist[top], ed))
            {
                dist[y] = std::max(dist[top], ed);
                pq.emplace(-dist[y], y);
            }
        }
    }

    std::cout << dist[n] << '\n';
}

void read()
{
    std::cin >> n >> m >> k;
    for (int i = 1 ; i <= m ; ++i)
    {
        int x, y, d;
        std::cin >> x >> y >> d;
        g[x].emplace_back(y, d);
        g[y].emplace_back(x, d);
    }
}

void fastIOI()
{
    std::ios_base :: sync_with_stdio(0);
    std::cout.tie(nullptr);
    std::cin.tie(nullptr);
}

int main()
{
    fastIOI();
    read();
    solve();

    return 0;
}
