#include <algorithm>
#include <iostream>
#include <numeric>
#include <cassert>
#include <cstring>
#include <vector>

typedef long long llong;
const int MAXN = 3000 + 10;
const llong INF  = 1e15;

int n, m, k;
llong dp[MAXN][MAXN];
bool bl[MAXN][MAXN];
std::vector <std::pair <int,int>> g[MAXN];

llong f(int node, int times)
{
    if (node == n) return 0;
    if (times == k) return INF;
    if (bl[node][times]) return dp[node][times];

    bl[node][times] = true;
    dp[node][times] = INF;
    for (const auto &[y, ed] : g[node])
    {
        dp[node][times] = std::min(dp[node][times], f(y, times + 1) + ed);
    }

    return dp[node][times];
}

void solve()
{
    std::cout << f(1, 0) << '\n';
}

void read()
{
    std::cin >> n >> m >> k;
    for (int i = 1 ; i <= m ; ++i)
    {
        int x, y, d;
        std::cin >> x >> y >> d;
        g[x].emplace_back(y, d);
        g[y].emplace_back(x, d);
    }
}

void fastIOI()
{
    std::ios_base :: sync_with_stdio(0);
    std::cout.tie(nullptr);
    std::cin.tie(nullptr);
}

int main()
{
    fastIOI();
    read();
    solve();

    return 0;
}
