#include <algorithm>
#include <iostream>
#include <numeric>
#include <cassert>
#include <cstring>
#include <vector>

typedef long long llong;
const int MAXN = 3000 + 10;
const int INF  = 2e9;

int n, m, k;
int perm[MAXN];
int dist[MAXN][MAXN];
std::vector <int> v;

void solve()
{
    llong ans = 1e15;
    std::iota(perm + 1, perm + 1 + n, 1);
    do
    {
        v.clear();
        llong curr = 0;
        bool solution = true;
        for (int i = 1 ; i <= n ; ++i)
        {
            if (perm[i] == n) break;
            if (dist[perm[i]][perm[i + 1]] == INF)
            {
                solution = false;
                break;
            }

            v.push_back(dist[perm[i]][perm[i + 1]]);
        }

        std::sort(v.begin(), v.end(), std::greater <int>());
        for (int i = 0 ; i < std::min(k, (int)v.size()) ; ++i)
        {
            curr += v[i];
        }

        if (solution) ans = std::min(ans, curr);
    } while(std::next_permutation(perm + 2, perm + 1 + n));
    std::cout << ans << '\n';
}

void read()
{
    std::fill(&dist[0][0], &dist[MAXN-1][MAXN-1] + 1, INF);
    std::cin >> n >> m >> k;
    for (int i = 1 ; i <= m ; ++i)
    {
        int x, y, d;
        std::cin >> x >> y >> d;
        dist[x][y] = std::min(dist[x][y], d);
        dist[y][x] = std::min(dist[y][x], d);
    }
}

void fastIOI()
{
    std::ios_base :: sync_with_stdio(0);
    std::cout.tie(nullptr);
    std::cin.tie(nullptr);
}

int main()
{
    fastIOI();
    read();
    solve();

    return 0;
}
