#include <algorithm>
#include <iostream>
#include <numeric>
#include <cassert>
#include <cstring>
#include <vector>

typedef long long llong;
const int MAXB = (1 << 15) + 10;
const int MAXM = 300 + 10;
const int MAXD = 300 + 10;
const int MOD  = 1e9 + 7;
const int MAXN = 15 + 5;
const int MAXK = 5 + 2;
const int INF  = 1e9;

int n, m, k;
int wordSize[MAXM];
char key[MAXN][MAXK];
char word[MAXM][MAXD];
std::string key2[MAXN];
std::string word2[MAXM];
int wordIsNext[MAXM][MAXN][MAXK];
std::vector <int> fillingWords[MAXN][MAXK];
std::vector <int> addWords[MAXN][MAXK];
std::vector <int> nextKeys[MAXM][MAXK];
int addMask[MAXM][MAXK];

inline bool matchSuffix(int idx1, int idx2, int taken)
{
    if (wordSize[idx2] < k - taken) return false;
    for (int i = 0 ; i <= k - taken - 1 ; ++i)
    {
        if (key[idx1][taken + i] != word[idx2][i]) return false;
    }

    return true;
}

inline bool matchAdd(int idx1, int idx2, int taken)
{
    if (wordSize[idx2] >= k - taken) return false;
    for (int i = 0 ; i <= wordSize[idx2] - 1 ; ++i)
    {
        if (key[idx1][taken + i] != word[idx2][i]) return false;
    }

    return true;
}


inline bool matchPrefix(int idx1, int idx2, int toMatch)
{
    assert(k >= toMatch);
    for (int i = 0 ; i <= toMatch - 1 ; ++i)
    {
        if (key[idx1][i] != word[idx2][wordSize[idx2] - toMatch + i]) return false;
    }

    return true;
}

int findMatch(int idx, int pos)
{
    for (int i = 1 ; i <= n ; ++i)
    {
        for (int j = 0 ; j <= k - 1 ; ++j)
        {
            if (key[i][j] != word[idx][pos + j]) break;
            if (j == k - 1) return i;
        }
    }

    return -1;
}

int dpWays[MAXB][MAXN][MAXK];
bool blWays[MAXB][MAXN][MAXK];
int dpSmallest[MAXB][MAXN][MAXK];
bool blSmallest[MAXB][MAXN][MAXK];

int fWays(int mask, int last, int taken)
{
    //std::cout << "call dp: " << mask << ' ' << last << ' ' << taken << '\n';
    if (__builtin_popcount(mask) == n && taken == k)
    {
        return 1;
    }

    if (blWays[mask][last][taken])
    {
        return dpWays[mask][last][taken];
    }

    blWays[mask][last][taken] = true;
    for (int i = 1 ; i <= m ; ++i)
    {
        if (wordIsNext[i][last][taken] == 0) continue;
        if (wordIsNext[i][last][taken] == 2)
        {
            dpWays[mask][last][taken] += fWays(mask, last, taken + wordSize[i]);
            if (dpWays[mask][last][taken] >= MOD) dpWays[mask][last][taken] -= MOD;
            continue;
        }

        int takenFromWord = k - taken;
        if (wordIsNext[i][last][taken] == 1 && addMask[i][takenFromWord] != -1 && (mask & addMask[i][takenFromWord]) == 0)
        {
            int newMask = mask | addMask[i][takenFromWord];
            if (newMask == (1 << n) - 1)
            {
                if ((wordSize[i] - takenFromWord) % k != 0) continue;
                dpWays[mask][last][taken]++;
                if (dpWays[mask][last][taken] >= MOD) dpWays[mask][last][taken] -= MOD;
                continue;
            }
            for (int j : nextKeys[i][takenFromWord])
            {
                if (newMask & (1 << j-1)) continue;
                dpWays[mask][last][taken] += fWays(newMask | (1 << j-1), j, (wordSize[i] - takenFromWord) % k);
                if (dpWays[mask][last][taken] >= MOD) dpWays[mask][last][taken] -= MOD;
            }
        }
    }

    return dpWays[mask][last][taken];
}

int fSmallest(int mask, int last, int taken)
{
    if (__builtin_popcount(mask) == n && taken == k)
    {
        return 0;
    }

    if (blSmallest[mask][last][taken])
    {
        return dpSmallest[mask][last][taken];
    }

    blSmallest[mask][last][taken] = true;
    dpSmallest[mask][last][taken] = -1;
    for (int i = 1 ; i <= m ; ++i)
    {
        if (wordIsNext[i][last][taken] == 0) continue;
        if (wordIsNext[i][last][taken] == 2 && fSmallest(mask, last, taken + wordSize[i]) != -1)
        {
            dpSmallest[mask][last][taken] = i;
            break;
        }

        int takenFromWord = k - taken;
        if (wordIsNext[i][last][taken] == 1 && addMask[i][takenFromWord] != -1 && (mask & addMask[i][takenFromWord]) == 0)
        {
            int newMask = mask | addMask[i][takenFromWord];
            if (newMask == (1 << n) - 1)
            {
                if ((wordSize[i] - takenFromWord) % k != 0) continue;
                dpSmallest[mask][last][taken] = i;
                break;
            }

            for (int j : nextKeys[i][takenFromWord])
            {
                if (newMask & (1 << j-1)) continue;
                if (fSmallest(newMask | (1 << j-1), j, (wordSize[i] - takenFromWord) % k) != -1)
                {
                    dpSmallest[mask][last][taken] = i;
                    break;
                }
            }

            if (dpSmallest[mask][last][taken] != -1) break;
        }
    }

    return dpSmallest[mask][last][taken];
}

std::vector <int> solution;
void solve()
{
    std::sort(key2 + 1, key2 + 1 + n);
    std::sort(word2 + 1, word2 + 1 + m);
    for (int i = 1 ; i <= m ; ++i)
    {
        wordSize[i] = word2[i].size();
        for (int j = 0 ; j < wordSize[i] ; ++j)
        {
            word[i][j] = word2[i][j];
        }

        word[i][wordSize[i]] = '\0';
    }

    for (int i = 1 ; i <= n ; ++i)
    {
        for (int j = 0 ; j < k ; ++j)
        {
            key[i][j] = key2[i][j];
        }

        key[i][k] = '\0';
    }

    /*std::cout << "sorted words\n";
    for (int i = 1 ; i <= m ; ++i)
    {
        std::cout << word[i] << '\n';
    }

    std::cout << "sorted keys\n";
    for (int i = 1 ; i <= n ; ++i)
    {
        std::cout << key[i] << '\n';
    }*/

    for (int idx = 1 ; idx <= n ; ++idx)
    {
        for (int taken = 0 ; taken <= k ; ++taken)
        {
            for (int i = 1 ; i <= m ; ++i)
            {
                if (matchSuffix(idx, i, taken))
                {
                    wordIsNext[i][idx][taken] = 1;
                    fillingWords[idx][taken].push_back(i);
                }

                if (matchAdd(idx, i, taken))
                {
                    wordIsNext[i][idx][taken] = 2;
                    addWords[idx][taken].push_back(i);
                }
            }
        }
    }

    /*std::cout << "filling words\n";
    for (const int &i : fillingWords[2][0])
    {
        std::cout << word[i] << '\n';
    }

    std::cout << "filling words\n";
    for (const int &i : fillingWords[2][0])
    {
        std::cout << word[i] << '\n';
    }*/

    for (int idx = 1 ; idx <= m ; ++idx)
    {
        for (int taken = 0 ; taken <= k ; ++taken)
        {
            int currMask = 0;
            for (int times = 0 ; taken + (times + 1) * k <= wordSize[idx] ; ++times)
            {
                int next = findMatch(idx, taken + times * k);
                //if (idx == 3 && taken == 0) std::cout << "find match: " << taken + times * k << ' ' << next << '\n';
                if (next == -1 || currMask & (1 << next - 1))
                {
                    currMask = -1;
                    break;
                }

                currMask |= (1 << next-1);
            }

            //if (idx == 4 && taken == 0) std::cout << "mask is: " << currMask << '\n';
            if (taken > wordSize[idx]) currMask = -1;
            addMask[idx][taken] = currMask;
            if (currMask != -1)
            {
                for (int next = 1 ; next <= n ; ++next)
                {
                    if (currMask & (1 << next - 1)) continue;
                    if (matchPrefix(next, idx, (wordSize[idx] - taken) % k))
                    {
                        nextKeys[idx][taken].push_back(next);
                    }
                }
            }
        }
    }

    /*std::cout << "addMask: " << addMask[3][0] <<  '\n';
    std::cout << "nextKeys:\n";
    for (const int &i : nextKeys[3][0])
    {
        std::cout << key[i] << '\n';
    }*/

    int ways = 0;
    for (int i = 1 ; i <= n ; ++i)
    {
        ways += fWays((1 << i-1), i, 0);
        if (ways >= MOD) ways -= MOD;
        // std::cout << " beginning with: " << i << ' ' << ways << '\n';
    }

    // std::cout << ways << '\n';
    for (int i = 1 ; i <= n ; ++i)
    {
        // std::cout << "smallest: " << i << " = " << fSmallest((1 << i-1), i, 0) << '\n';
        if (fSmallest((1 << i-1), i, 0) != -1)
        {
            int mask = (1 << i-1);
            int last = i;
            int taken = 0;
            while (true)
            {
                // std::cout << "finding solution: " << mask << ' ' << last << ' ' << taken << '\n';
                if (mask == (1 << n) - 1 && taken == k)
                {
                    break;
                }

                int currWord = fSmallest(mask, last, taken);
                if (currWord == -1)
                {
                    // std::cout << "wtf\n";
                    exit(-1);
                    return;
                }

                if (wordIsNext[currWord][last][taken] == 2 && fSmallest(mask, last, taken + wordSize[currWord]) != -1)
                {
                    solution.push_back(currWord);
                    taken += wordSize[currWord];
                    continue;
                }

                int takenFromWord = k - taken;
                if (wordIsNext[currWord][last][taken] == 1 && addMask[currWord][takenFromWord] != -1 && (mask & addMask[currWord][takenFromWord]) == 0)
                {
                    int newMask = mask | addMask[currWord][takenFromWord];
                    if (newMask == (1 << n) - 1)
                    {
                        if ((wordSize[currWord] - takenFromWord) % k != 0) continue;
                        solution.push_back(currWord);
                        break;
                    }

                    for (int j : nextKeys[currWord][takenFromWord])
                    {
                        if (newMask & (1 << j-1)) continue;
                        if (fSmallest(newMask | (1 << j-1), j, (wordSize[currWord] - takenFromWord) % k) != -1)
                        {
                            mask = newMask | (1 << j-1);
                            last = j;
                            taken = (wordSize[currWord] - takenFromWord) % k;
                            solution.push_back(currWord);
                            break;
                        }
                    }
                }
            }

            break;
        }
    }

    for (const int &i : solution)
    {
        std::cout << word[i] << ' ';
    }

    std::cout << '\n';
    std::cout << ways << '\n';
}

void read()
{
    std::cin >> n >> k;
    for (int i = 1 ; i <= n ; ++i)
    {
        std::cin >> key2[i];
    }

    std::cin >> m;
    for (int i = 1 ; i <= m ; ++i)
    {
        std::cin >> word2[i];
    }
}

void fastIOI()
{
    std::ios_base :: sync_with_stdio(0);
    std::cout.tie(nullptr);
    std::cin.tie(nullptr);
}

int main()
{
    fastIOI();
    read();
    solve();

    return 0;
}
