#include <algorithm>
#include <iostream>
#include <numeric>
#include <cassert>
#include <vector>

typedef long long llong;
const int MAXLOG = 20;
const int MAXN = 200000 + 10;
const int INF  = 1e9;

int n, q;
int num[MAXN];
std::vector <std::pair <int,int>> g[MAXN];
std::vector <int> cycle;
int sparse[MAXLOG][MAXN];
int parCycle[MAXN];
int toCycle[MAXN];
int inCycle[MAXN];

bool vis[MAXN];
int dfsCycle(int node, int last)
{
    if (vis[node])
    {
        return node;
    }

    vis[node] = true;
    for (const auto &[i, ed] : g[node])
    {
        if (i == last) continue;
        int res = dfsCycle(i, node);
        if (res == -2) return -2;
        if (res != -1)
        {
            inCycle[node] = cycle.size();
            cycle.push_back(ed);
            if (node == res) return -2;
            return res;
        }
    }

    return -1;
}

void dfsTrees(int start, int node, int par, int max)
{
    toCycle[node] = max;
    parCycle[node] = start;
    for (const auto &[i, ed] : g[node])
    {
        if (i == par) continue;
        if (inCycle[i] != -1) continue;
        dfsTrees(start, i, node, std::max(max, ed));
    }
}

int getLog[MAXN];
void buildSparse()
{
    for (int i = 0 ; i < cycle.size() ; ++i)
    {
        sparse[0][i] = cycle[i];
    }

    for (int log = 1 ; (1 << log) <= cycle.size() ; ++log)
    {
        for (int i = 0 ; i + (1 << log) - 1 < cycle.size() ; ++i)
        {
            sparse[log][i] = std::max(sparse[log - 1][i], sparse[log - 1][i + (1 << log-1)]);
        }
    }

    for (int i = 1 ; i <= cycle.size() ; ++i)
    {
        getLog[i] = getLog[i - 1];
        if ((1 << getLog[i] + 1) < i) ++getLog[i];
    }
}

inline int findMAX(int l, int r)
{
    int log = getLog[r-l+1];
    return std::max(sparse[log][l], sparse[log][r - (1 << log) + 1]);
}

void solve()
{
    std::fill(inCycle + 1, inCycle + 1 + n, -1);
    dfsCycle(1, 0);
    for (int i = 1 ; i <= n ; ++i)
    {
        if (inCycle[i] != -1)
        {
            dfsTrees(i, i, 0, 0);
        }
    }

    buildSparse();
    llong ans = 0;
    std::cin >> q;
    int qType, x, y;
    std::iota(num + 1, num + 1 + n, 1);
    for (int i = 1 ; i <= q ; ++i)
    {
        std::cin >> qType >> x >> y;
        if (qType == 2)
        {
            std::swap(num[x], num[y]);
            continue;
        }

        x = num[x]; y = num[y];
        if (qType == 1)
        {
            int distA = toCycle[x];
            int distB = toCycle[y];
            int a = parCycle[x];
            int b = parCycle[y];
            if (inCycle[a] > inCycle[b]) std::swap(a, b);
            int ans1 = std::max(distA, distB);
            int ans2 = std::max(distA, distB);
            if (inCycle[a] + 1 <= inCycle[b])
            {
                ans1 = std::max(ans1, findMAX(inCycle[a] + 1, inCycle[b]));
            }

            if (0 <= inCycle[a])
            {
                ans2 = std::max(ans2, findMAX(0, inCycle[a]));
            }

            if (inCycle[b] + 1 < cycle.size())
            {
                ans2 = std::max(ans2, findMAX(inCycle[b] + 1, (int)cycle.size() - 1));
            }

            ans += 2*std::max(ans1, ans2) + std::min(ans1, ans2);
        }
    }

    std::cout << ans << '\n';
}

void read()
{
    int x, y, d;
    std::cin >> n;
    for (int i = 1 ; i <= n ; ++i)
    {
        std::cin >> x >> y >> d;
        g[x].emplace_back(y, d);
        g[y].emplace_back(x, d);
    }
}

void fastIOI()
{
    std::ios_base :: sync_with_stdio(0);
    std::cout.tie(nullptr);
    std::cin.tie(nullptr);
}

int main()
{
    fastIOI();
    read();
    solve();

    return 0;
}
