#include <bits/stdc++.h>
using namespace std;
#define endl "\n"
typedef long long ll;
template<class T, class T2> bool chkmin(T &a, const T2 &b) { return (a > b) ? a = b, 1 : 0; }
template<class T, class T2> bool chkmax(T &a, const T2 &b) { return (a < b) ? a = b, 1 : 0; }

#ifndef LOCAL
#define cerr if(false)cerr
#endif // LOCAL

const ll MAX_N = 3e3 + 10;
vector<pair<ll, ll> > g[MAX_N];
ll n, m, k;
pair<ll, ll> orig[MAX_N];
pair<ll, ll> cost[MAX_N];
ll dist[MAX_N][MAX_N];

namespace min_spanning {

int par[MAX_N], sz[MAX_N];

void init() {
    for(int i = 0; i < MAX_N; i ++) {
        par[i] = i;
        sz[i] = 1;
    }
}

int find(int x) {
    if(x == par[x]) {
        return x;
    } else {
        return par[x];
    }
}

bool merge(int x, int y) {
    x = find(x); y = find(y);
    if(x == y) { return false; }
    if(sz[x] < sz[y]) { swap(x, y); }
    par[y] = x;
    sz[x] += sz[y];
    return true;
}

};

ll solve(ll x) {
    for(ll i = 1; i <= n; i ++) {
        for(ll j = 0; j <= k; j ++) {
            dist[i][j] = 1e15;
        }
    }

    priority_queue<pair<ll, pair<ll, ll> > > pq;
    pq.push({0, {1, 0}});

    while(!pq.empty()) {
        auto curr = pq.top(); pq.pop();
        curr.first *= -1;

        for(const auto &it : g[curr.second.first]) {
            ll newk = curr.second.second + (ll)(orig[it.second].second >= x);
            ll cost = (orig[it.second].second >= x) ? orig[it.second].first : 0;
            if(newk > k) { continue; }
            if(dist[it.first][newk] > curr.first + cost) {
                dist[it.first][newk] = curr.first + cost;
                pq.push({-dist[it.first][newk], {it.first, newk}});
            }
        }
    }

    ll ret = dist[n][k];
    if(x == 0) {
        for(int i = 0; i <= k; i ++) {
            chkmin(ret, dist[n][i]);
        }
    }

    return ret;
}

vector<pair<int, pair<int, int> > > edges;
vector<pair<int, pair<int, int> > > filtered;

signed main() {
    ios_base::sync_with_stdio(false); cin.tie(NULL); cout.tie(NULL);

    min_spanning::init();

    ll ans = 1e15;

    cin >> n >> m >> k;
    for(ll i = 0; i < m; i ++) {
        ll a, b, c;
        cin >> a >> b >> c;
        edges.push_back({c, {a, b}});
        g[a].push_back({b, i});
        g[b].push_back({a, i});
        orig[i] = {c, i};
    }

    chkmin(ans, solve(0));
    for(int i = 0; i <= n; i ++) {
        g[i].resize(0);
    }

    cout << ans << endl;
    return 0;

    sort(edges.begin(), edges.end());
    for(const auto &it : edges) {
        if(min_spanning::merge(it.second.first, it.second.second)) {
            filtered.push_back(it);
        }
    }

    for(int i = 0; i < filtered.size(); i ++) {
        int a = filtered[i].second.first;
        int b = filtered[i].second.second;
        int c = filtered[i].first;
        g[a].push_back({b, i});
        g[b].push_back({a, i});
        orig[i] = {c, i};
        cost[i] = {c, i};
    }

    m = filtered.size();
    sort(cost, cost + m);

    for(ll i = 0; i < m; i ++) {
        orig[cost[i].second].second = i;
    }

    for(ll i = 0; i < m; i ++) {
        chkmin(ans, solve(i));
    }

    cout << ans << endl;

    return 0;
}
