#include <bits/stdc++.h>
using namespace std;
#define endl "\n"
typedef long long ll;
template<class T, class T2> bool chkmin(T &a, const T2 &b) { return (a > b) ? a = b, 1 : 0; }
template<class T, class T2> bool chkmax(T &a, const T2 &b) { return (a < b) ? a = b, 1 : 0; }

#ifndef LOCAL
#define cerr if(false)cerr
#endif // LOCAL

const ll MAX_N = 3e3 + 10;
vector<pair<ll, ll> > g[MAX_N];
ll n, m, k;
pair<ll, ll> orig[MAX_N];
pair<ll, ll> cost[MAX_N];
ll dist[MAX_N][MAX_N];

ll solve(ll x) {
    cerr << "SOLVING FOR " << x << endl;
    for(ll i = 1; i <= n; i ++) {
        for(ll j = 0; j <= k; j ++) {
            dist[i][j] = 1e15;
        }
    }

    priority_queue<pair<ll, pair<ll, ll> > > pq;
    pq.push({0, {1, 0}});

    while(!pq.empty()) {
        auto curr = pq.top(); pq.pop();
        curr.first *= -1;

        for(const auto &it : g[curr.second.first]) {
            ll newk = curr.second.second + (ll)(orig[it.second].second >= x);
            ll cost = (orig[it.second].second >= x) ? orig[it.second].first : 0;
            if(newk > k) { continue; }
            if(dist[it.first][newk] > curr.first + cost) {
                dist[it.first][newk] = curr.first + cost;
                pq.push({-dist[it.first][newk], {it.first, newk}});
            }
        }
    }

    ll ret = dist[n][k];
    if(x == 0) {
        for(int i = 0; i <= k; i ++) {
            chkmin(ret, dist[n][i]);
        }
    }

    cerr << x << " solved for " << dist[n][k] << endl;

    return ret;
}

signed main() {
    ios_base::sync_with_stdio(false); cin.tie(NULL); cout.tie(NULL);

    cin >> n >> m >> k;
    for(ll i = 0; i < m; i ++) {
        ll a, b, c;
        cin >> a >> b >> c;
        g[a].push_back({b, i});
        g[b].push_back({a, i});
        orig[i] = {c, i};
        cost[i] = {c, i};
    }

    sort(cost, cost + m);

    for(ll i = 0; i < m; i ++) {
        orig[cost[i].second].second = i;
    }

    ll ans = 1e15;

    for(ll i = 0; i < m; i ++) {
        chkmin(ans, solve(i));
    }

    cout << ans << endl;

    return 0;
}
