#include <bits/stdc++.h>

#define MAXN 50005

using namespace std;

int n, m, k;
vector<int> g[MAXN];
vector<int> r[MAXN];
bool used[MAXN];
int takes[MAXN];

void Init() {
    for (int i = 1; i <= n; i++) used[i] = false;
}

void DFS1(int u) {
    used[u] = true;
    takes[u]++;

    for (int v : g[u]) {
        if (!used[v]) DFS1(v);
    }
}

void DFS2(int u) {
    used[u] = true;
    takes[u]++;

    for (int v : r[u]) {
        if (!used[v]) DFS2(v);
    }
}

int main() {
    ios_base::sync_with_stdio(0); cin.tie(0); cout.tie(0);

    cin >> n >> m >> k;
    for (int i = 0; i < m; i++) {
        int u, v; cin >> u >> v;
        g[u].push_back(v);
        r[v].push_back(u);
    }

    vector<int> end_destinations;

    for (int i = 0; i < k; i++) {
        int u, v; cin >> u >> v;
        end_destinations.push_back(v);

        Init();
        DFS1(u);
    }

    for (int i = 0; i < k; i++) {
        Init();
        DFS2(end_destinations[i]);
    }

    vector<int> ans;

    for (int i = 1; i <= n; i++) {
        if (takes[i] == 2 * k) {
            ans.push_back(i);
        }
    }

    cout << ans.size() << endl;
    for (int element : ans) cout << element << " "; cout << endl;

    return 0;
}
