#include <bits/stdc++.h>

#define MAXN 50005

using namespace std;

int n, m, k;
vector<int> g[MAXN];
bool used[MAXN];
int takes[MAXN];

void Init() {
    for (int i = 1; i <= n; i++) used[i] = false;
}

void DFS1(int u) {
    used[u] = true;
    takes[u]++;

    for (int v : g[u]) {
        if (!used[v]) DFS1(v);
    }
}

void DFS2(int u) {
    used[u] = true;

    for (int v : g[u]) {
        if (!used[v]) DFS2(v);
    }
}

int main() {
    ios_base::sync_with_stdio(0); cin.tie(0); cout.tie(0);

    cin >> n >> m >> k;
    for (int i = 0; i < m; i++) {
        int u, v; cin >> u >> v;
        g[u].push_back(v);
    }

    if (k == 1) {
        int u, v; cin >> u >> v;
        DFS2(u);

        vector<int> ve;

        for (int i = 1; i <= n; i++) {
            if (used[i]) {
                Init();
                DFS1(i);

                if (used[v]) ve.push_back(i);
            }
        }

        cout << ve.size() << endl;
        for (int element : ve) cout << element << " "; cout << endl;

        return 0;
    }

    vector<int> end_destinations;

    for (int i = 0; i < k; i++) {
        int u, v; cin >> u >> v;
        end_destinations.push_back(v);

        Init();
        DFS1(u);
    }

    vector<int> ans;

    for (int i = 1; i <= n; i++) {
        if (takes[i] == k) {
            Init();
            DFS2(i);

            bool flag = false;
            for (int j = 0; j < k; j++) {
                if (!used[end_destinations[j]]) {
                    flag = true;
                    break;
                }
            }

            if (!flag) ans.push_back(i);
        }
    }

    cout << ans.size() << endl;
    for (int element : ans) cout << element << " "; cout << endl;

    return 0;
}
