#include <bits/stdc++.h>

#define MAXN 100005

using namespace std;

int n, k;
int a[MAXN];
vector<int> curr_bits[32];

void Add(int x, int idx) {
    for (int i = 0; i <= 31; i++) {
        if (x % 2 == 1) curr_bits[i].push_back(idx);
        x = x / 2;
    }
}

vector<bool> get_bits(int x) {
    vector<bool> bits(32, 0);

    for (int i = 0; i <= 31; i++) {
        bits[i] = x % 2;
        x = x / 2;
    }

    return bits;
}

long long without(int idx, long long bitwise_or) {
    vector<bool> or_bits = get_bits(bitwise_or);
    long long new_bitwise_or = 0;

    for (int i = 0; i <= 31; i++) {
        if (or_bits[i] == 1 && curr_bits[i].size() == 1 && curr_bits[i][0] == idx) {
            or_bits[i] = 0;
        }
    }

    int last_one_idx = 32;
    for (int i = 31; i >= 0; i--) {
        if (or_bits[i] == 1) {
            last_one_idx = i;
            break;
        }
    }

    if (last_one_idx == 32) return 0;

    for (int i = 0; i <= last_one_idx; i++) {
        new_bitwise_or = new_bitwise_or * 2 + or_bits[i];
    }

    return new_bitwise_or;
}

int main() {
    ios_base::sync_with_stdio(0); cin.tie(0); cout.tie(0);

    cin >> n >> k;

    for (int i = 1; i <= n; i++) cin >> a[i];

    int j = 0;
    long long ans = 1LL * n * (n + 1) / 2;
    long long bitwise_or = 0;

    for (int i = 1; i <= n; i++) {
        for (int k = 0; k <= 31; k++) curr_bits[k].clear();

        while (j + 1 <= n && (bitwise_or | a[j + 1]) < k) {
            j++;
            bitwise_or = bitwise_or | a[j];
            Add(a[j], j);
        }

        //cout << i << " " << j << " " << bitwise_or << endl;

        if (j >= i) {
            long long len = j - i + 1;
            //cout << i << " length = " << len << endl;
            ans = ans - len;

            if (j - i + 1 > 1) bitwise_or = without(i, bitwise_or);
            else bitwise_or = 0;
        } else {
            j = i;
        }
    }

    cout << ans << endl;

    return 0;
}
